/* Copyright (C) 2005 Felipe Leme. All rights reserved.
 * 
 * This program and the accompanying materials are made available under
 * the terms of the Common Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/cpl-v10.html
 */
package com.vladium.emma.test;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

/**
 * Test cases for the JDTHelper class.
 *
 * @author Felipe Leme <emma@felipeal.net>
 *
 */
public class JDTHelperTest extends AbstractProjectTestCase {
      
  public JDTHelperTest( String testName ) throws Exception {
    super( testName );
  }

  public void testSetJavaNature() throws CoreException {    
    final boolean hadBefore = super.fProject.hasNature( JavaCore.NATURE_ID );
    assertFalse( "had Java Nature already" , hadBefore );
    JDTHelper.setJavaNature( super.fProject );
    final boolean hasAfter = super.fProject.hasNature( JavaCore.NATURE_ID );
    assertTrue( "Java Nature not set" , hasAfter );
  }  
  
  public void testGetJavaProject() throws CoreException {
    final IJavaProject javaProject = JDTHelper.createJavaProject( super.fProject );
    assertNotNull( "java project is null", javaProject );
  }
  

}
