/* Copyright (C) 2005 Erik Beijnoff. All rights reserved.
 * 
 * This program and the accompanying materials are made available under
 * the terms of the Common Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/cpl-v10.html
 */
package com.vladium.emma.test;

/**
 * @author Erik Beijnoff erik@beijnoff.com
 * @since 2006-02-08
 */
public class StandardFixtureTest extends StandardFixtureTestCase{
	public StandardFixtureTest(String testName) throws Exception{
		super(testName);
	}

	public void testInternalExists(){
		assertNotNull("internal project is null", this.internalProject);
	}

	public void testClosedExists(){
		assertNotNull("closed project is null", this.closedProject);
	}

	public void testClosedClosed(){
		final boolean isClosed= !this.closedProject.getJavaProject().getProject().isOpen();
		assertTrue("presumed closed project is not closed", isClosed);
	}
}