/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.ctl;

import com.vladium.emma.ant.NestedTask;
import com.vladium.emma.ant.SuppressableTask;
import com.vladium.emma.ctl.ControlRequest;
import com.vladium.emma.ctl.CtlProcessor;
import com.vladium.emma.ctl.ctlCommand;
import com.vladium.util.IConstants;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public final class ctlTask
extends NestedTask {
    private String m_connectionString;
    private List m_commands = new ArrayList();

    public ctlTask(SuppressableTask parent) {
        super(parent);
    }

    public void execute() throws BuildException {
        if (this.isEnabled()) {
            CtlProcessor processor = CtlProcessor.create();
            processor.setConnectionString(this.m_connectionString);
            processor.setCommandSequence(this.getCommands());
            processor.setPropertyOverrides(this.getTaskSettings());
            processor.run();
        }
    }

    public final void setConnect(String connectionString) {
        this.m_connectionString = connectionString;
    }

    public final commandElement createCommand() {
        commandElement command = new commandElement(this);
        this.m_commands.add(command);
        return command;
    }

    private ControlRequest[] getCommands() {
        ArrayList<ControlRequest> _result = new ArrayList<ControlRequest>(this.m_commands.size());
        int r = 0;
        Iterator i = this.m_commands.iterator();
        while (i.hasNext()) {
            commandElement command = (commandElement)i.next();
            String name = command.getName();
            String[] args = command.getArgs();
            if (name == null) {
                if (args != null) {
                    throw (BuildException)ctlTask.newBuildException(this.getTaskName() + ": command name must be specified", this.location).fillInStackTrace();
                }
            } else {
                _result.add(ControlRequest.create((String)name, (String[])args));
            }
            ++r;
        }
        ControlRequest[] result = new ControlRequest[_result.size()];
        _result.toArray(result);
        return result;
    }

    public static final class commandElement {
        private final Task m_task;
        private String m_name;
        private String[] m_args;

        public final void setName(String name) {
            if (this.m_name != null) {
                throw (BuildException)SuppressableTask.newBuildException(this.m_task.getTaskName() + ": command name already set", this.m_task.getLocation()).fillInStackTrace();
            }
            this.m_name = name;
        }

        public final void setArgs(String args) {
            if (this.m_args != null) {
                throw (BuildException)SuppressableTask.newBuildException(this.m_task.getTaskName() + ": command arguments already set", this.m_task.getLocation()).fillInStackTrace();
            }
            this.m_args = ctlCommand.tokenize((String)args, (String)",", (boolean)true);
        }

        public final void addText(String cmd) {
            if (cmd != null && cmd.trim().length() > 0) {
                if (this.m_name != null || this.m_args != null) {
                    throw (BuildException)SuppressableTask.newBuildException(this.m_task.getTaskName() + ": command name/arguments already set", this.m_task.getLocation()).fillInStackTrace();
                }
                String[] _command = ctlCommand.tokenize((String)cmd, (String)",", (boolean)true);
                if (_command.length > 1) {
                    this.m_name = _command[0];
                    this.m_args = new String[_command.length - 1];
                    System.arraycopy(_command, 1, this.m_args, 0, this.m_args.length);
                } else {
                    this.m_name = _command[0];
                    this.m_args = IConstants.EMPTY_STRING_ARRAY;
                }
            }
        }

        commandElement(Task task) {
            if (task == null) {
                throw new IllegalArgumentException("null input: task");
            }
            this.m_task = task;
        }

        final String getName() {
            return this.m_name;
        }

        final String[] getArgs() {
            return this.m_args;
        }
    }
}

