/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.service.image;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.facebook.cache.common.CacheKey;
import com.facebook.common.executors.UiThreadImmediateExecutorService;
import com.facebook.common.references.CloseableReference;
import com.facebook.datasource.BaseDataSubscriber;
import com.facebook.datasource.DataSource;
import com.facebook.datasource.DataSubscriber;
import com.facebook.drawable.base.DrawableWithCaches;
import com.facebook.drawee.backends.pipeline.DefaultDrawableFactory;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.fresco.animation.backend.AnimationBackend;
import com.facebook.fresco.animation.drawable.AnimatedDrawable2;
import com.facebook.fresco.animation.drawable.BaseAnimationListener;
import com.facebook.imagepipeline.cache.MemoryCache;
import com.facebook.imagepipeline.common.ImageDecodeOptionsBuilder;
import com.facebook.imagepipeline.common.Priority;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.image.CloseableStaticBitmap;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.request.ImageRequestBuilder;
import com.lynx.react.bridge.ReadableMap;
import com.lynx.service.image.decoder.LoopCountModifyingBackend;
import com.lynx.service.image.utils.ImageUtils;
import com.lynx.tasm.LynxEnv;
import com.lynx.tasm.behavior.Behavior;
import com.lynx.tasm.behavior.LynxContext;
import com.lynx.tasm.behavior.shadow.ShadowNode;
import com.lynx.tasm.behavior.ui.LynxFlattenUI;
import com.lynx.tasm.behavior.ui.LynxUI;
import com.lynx.tasm.behavior.ui.background.BackgroundLayerDrawable;
import com.lynx.tasm.behavior.ui.image.BackgroundImageDrawable;
import com.lynx.tasm.behavior.ui.image.FlattenUIImage;
import com.lynx.tasm.behavior.ui.image.InlineImageShadowNode;
import com.lynx.tasm.behavior.ui.image.UIImage;
import com.lynx.tasm.image.AutoSizeImage;
import com.lynx.tasm.image.ImageContent;
import com.lynx.tasm.image.ImageErrorCodeUtils;
import com.lynx.tasm.image.model.AnimationListener;
import com.lynx.tasm.image.model.ImageInfo;
import com.lynx.tasm.image.model.ImageLoadListener;
import com.lynx.tasm.image.model.ImageRequestInfo;
import com.lynx.tasm.service.ILynxImageService;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;

@Keep
public class LynxImageService
implements ILynxImageService {
    public static final String PRIORITY_KEY = "priority";
    public static final String PRIORITY_LOW = "low";
    public static final String PRIORITY_MEDIUM = "medium";
    public static final String PRIORITY_HIGH = "high";
    public static final String CACHE_TARGET_KEY = "cacheTarget";
    public static final String CACHE_DISK = "disk";
    public static final String CACHE_BITMAP = "bitmap";
    private static volatile LynxImageService sInstance = null;
    private DefaultDrawableFactory mDefaultDrawableFactory;
    private MemoryCache<CacheKey, CloseableImage> mMemoryCache;
    ConcurrentHashMap<ImageRequestInfo, CloseableReference<CloseableImage>> mImageReferenceMap = new ConcurrentHashMap();
    private Resources mResources = null;
    private final UiThreadImmediateExecutorService mExecutorService = UiThreadImmediateExecutorService.getInstance();

    private LynxImageService() {
        ArrayList<Behavior> behaviorList = new ArrayList<Behavior>();
        behaviorList.add(new Behavior("image", true, true){

            public LynxUI createUI(LynxContext context) {
                return new UIImage(context);
            }

            public LynxFlattenUI createFlattenUI(LynxContext context) {
                return new FlattenUIImage(context);
            }

            public ShadowNode createShadowNode() {
                return new AutoSizeImage();
            }
        });
        behaviorList.add(new Behavior("inline-image", false, true){

            public ShadowNode createShadowNode() {
                return new InlineImageShadowNode();
            }
        });
        LynxEnv.inst().addBehaviors(behaviorList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LynxImageService getInstance() {
        if (sInstance != null) return sInstance;
        Class<LynxImageService> clazz = LynxImageService.class;
        synchronized (LynxImageService.class) {
            if (sInstance != null) return sInstance;
            sInstance = new LynxImageService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public void fetchImage(final @NonNull ImageRequestInfo imageRequestInfo, final @NonNull ImageLoadListener loadListener, final @Nullable AnimationListener animationListener, @NonNull Context context) {
        ImageRequest imageRequest;
        CloseableReference<CloseableImage> closeableReference;
        if (this.mResources == null) {
            this.mResources = context.getResources();
        }
        if (this.mDefaultDrawableFactory == null) {
            this.mDefaultDrawableFactory = new DefaultDrawableFactory(this.mResources, Fresco.getImagePipelineFactory().getAnimatedDrawableFactory(context));
        }
        if (this.mMemoryCache == null) {
            this.mMemoryCache = Fresco.getImagePipelineFactory().getBitmapMemoryCache();
        }
        if ((closeableReference = ImageUtils.getCachedImage(this.mMemoryCache, ImageUtils.getCacheKey(imageRequest = ImageUtils.getFrescoImageRequest(imageRequestInfo), imageRequestInfo.getCallerContext()))) != null) {
            CloseableImage image = (CloseableImage)closeableReference.get();
            this.mImageReferenceMap.put(imageRequestInfo, closeableReference);
            if (image instanceof CloseableStaticBitmap) {
                loadListener.onSuccess(new ImageContent(((CloseableStaticBitmap)image).getUnderlyingBitmap()), imageRequestInfo, new ImageInfo(image.getWidth(), image.getHeight(), false));
                return;
            }
        }
        Fresco.getImagePipeline().fetchDecodedImage(imageRequest, imageRequestInfo.getCallerContext()).subscribe((DataSubscriber)new BaseDataSubscriber<CloseableReference<CloseableImage>>(){

            protected void onNewResultImpl(DataSource<CloseableReference<CloseableImage>> dataSource) {
                LynxImageService.this.handleImageLoadSuccess((DataSource<CloseableReference<CloseableImage>>)dataSource, imageRequestInfo, loadListener, animationListener);
            }

            protected void onFailureImpl(DataSource<CloseableReference<CloseableImage>> dataSource) {
                int errorCode = ImageErrorCodeUtils.checkImageException((Throwable)dataSource.getFailureCause());
                loadListener.onFailure(errorCode, dataSource.getFailureCause());
            }
        }, (Executor)this.mExecutorService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleImageLoadSuccess(DataSource<CloseableReference<CloseableImage>> dataSource, ImageRequestInfo imageRequestInfo, ImageLoadListener loadListener, AnimationListener animationListener) {
        CloseableReference reference = (CloseableReference)dataSource.getResult();
        try {
            CloseableImage image = (CloseableImage)reference.get();
            boolean isAnim = false;
            ImageContent content = null;
            if (image instanceof CloseableStaticBitmap) {
                content = new ImageContent(((CloseableStaticBitmap)image).getUnderlyingBitmap());
            } else {
                Drawable drawable = this.mDefaultDrawableFactory.createDrawable((CloseableImage)reference.get());
                content = new ImageContent(drawable);
                isAnim = this.handleImageAnimListener(imageRequestInfo, drawable, animationListener);
            }
            this.mImageReferenceMap.put(imageRequestInfo, (CloseableReference<CloseableImage>)reference.clone());
            loadListener.onSuccess(content, imageRequestInfo, new ImageInfo(image.getWidth(), image.getHeight(), isAnim));
        }
        catch (Exception exception) {
            CloseableReference.closeSafely((CloseableReference)reference);
            loadListener.onFailure(30102, (Throwable)exception);
        }
        finally {
            CloseableReference.closeSafely((CloseableReference)reference);
        }
    }

    private boolean handleImageAnimListener(ImageRequestInfo imageRequestInfo, Drawable drawable, final AnimationListener animationListener) {
        boolean isAnim = false;
        if (drawable instanceof AnimatedDrawable2) {
            isAnim = true;
            AnimatedDrawable2 animatedDrawable = (AnimatedDrawable2)drawable;
            if (animationListener != null) {
                animatedDrawable.setAnimationListener((com.facebook.fresco.animation.drawable.AnimationListener)new BaseAnimationListener(){

                    public void onAnimationStart(AnimatedDrawable2 drawable) {
                        animationListener.onAnimationStart((Drawable)drawable);
                    }

                    public void onAnimationStop(AnimatedDrawable2 drawable) {
                        if (drawable.isRunning()) {
                            animationListener.onAnimationCurrentLoop((Drawable)drawable);
                            animationListener.onAnimationFinalLoop((Drawable)drawable);
                        }
                    }

                    public void onAnimationRepeat(AnimatedDrawable2 drawable) {
                        if (drawable.isRunning()) {
                            animationListener.onAnimationCurrentLoop((Drawable)drawable);
                        }
                    }
                });
            }
            animatedDrawable.setAnimationBackend((AnimationBackend)new LoopCountModifyingBackend(animatedDrawable.getAnimationBackend(), imageRequestInfo.getLoopCount()));
            if (imageRequestInfo.isAutoPlay()) {
                animatedDrawable.start();
            }
        }
        return isAnim;
    }

    public boolean startAnimation(@NonNull Drawable animatable) {
        if (animatable instanceof AnimatedDrawable2) {
            ((AnimatedDrawable2)animatable).stop();
            ((AnimatedDrawable2)animatable).start();
            return true;
        }
        return false;
    }

    public boolean resumeAnimation(@NonNull Drawable animatable) {
        if (animatable instanceof AnimatedDrawable2) {
            ((AnimatedDrawable2)animatable).start();
            return true;
        }
        return false;
    }

    public boolean pauseAnimation(@NonNull Drawable animatable) {
        if (animatable instanceof AnimatedDrawable2) {
            ((AnimatedDrawable2)animatable).stop();
            return true;
        }
        return false;
    }

    public boolean stopAnimation(@NonNull Drawable animatable) {
        if (animatable instanceof AnimatedDrawable2) {
            ((AnimatedDrawable2)animatable).stop();
            return true;
        }
        return false;
    }

    private void prefetchImageToDiskCache(ImageRequest request, Object callerContext, @Nullable String priorityString) {
        Priority priority = priorityString != null && priorityString.equals(PRIORITY_HIGH) ? Priority.HIGH : (priorityString != null && priorityString.equals(PRIORITY_MEDIUM) ? Priority.MEDIUM : Priority.LOW);
        Fresco.getImagePipeline().prefetchToDiskCache(request, callerContext, priority);
    }

    private void prefetchImageToBitmapCache(ImageRequest request, Object callerContext) {
        Fresco.getImagePipeline().prefetchToBitmapCache(request, callerContext);
    }

    public void prefetchImage(@NonNull String uri, Object callerContext, @Nullable ReadableMap params) {
        String priorityString = params == null ? null : params.getString(PRIORITY_KEY, null);
        String cacheString = params == null ? null : params.getString(CACHE_TARGET_KEY, null);
        Uri imageUri = Uri.parse((String)uri);
        if (imageUri.getScheme() == null) {
            return;
        }
        ImageRequestBuilder builder = ImageRequestBuilder.newBuilderWithSource((Uri)imageUri);
        ImageDecodeOptionsBuilder decodeOptionsBuilder = new ImageDecodeOptionsBuilder().setBitmapConfig(Bitmap.Config.ARGB_8888);
        builder.setImageDecodeOptions(decodeOptionsBuilder.build());
        if (cacheString != null && cacheString.equals(CACHE_BITMAP)) {
            this.prefetchImageToBitmapCache(builder.build(), callerContext);
        } else {
            this.prefetchImageToDiskCache(builder.build(), callerContext, priorityString);
        }
    }

    public void releaseImage(@NonNull ImageRequestInfo imageRequestInfo) {
        CloseableReference<CloseableImage> closeableReference;
        if (imageRequestInfo != null && (closeableReference = this.mImageReferenceMap.remove(imageRequestInfo)) != null) {
            CloseableReference.closeSafely(closeableReference);
        }
    }

    public void releaseAnimDrawable(@NonNull Drawable drawable) {
        if (drawable instanceof DrawableWithCaches) {
            ((DrawableWithCaches)drawable).dropCaches();
        }
    }

    public boolean canParseUrl(@NonNull String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return true;
        }
        return url.startsWith("file://") || url.startsWith("content://") || url.startsWith("asset://") || url.startsWith("data:");
    }

    @Nullable
    public BackgroundLayerDrawable createBackgroundImageDrawable(@NonNull Context context, @NonNull String url) {
        return new BackgroundImageDrawable(context, url);
    }

    public void onLynxEnvSetup() {
    }

    @Deprecated
    public void setCustomImageDecoder(@NonNull Object builder) {
    }

    @Deprecated
    @Nullable
    public Object getImageSRPostProcessor() {
        return null;
    }

    @Deprecated
    public void setImageSRSize(@NonNull Object request, @NonNull View view) {
    }

    @Deprecated
    public void setImageCacheChoice(@NonNull String cacheChoice, @NonNull Object builder) {
    }

    @Deprecated
    public void setImagePlaceHolderHash(@NonNull Object hierarchy, @NonNull Object request, @NonNull Object scaleType, @NonNull String hash, @Nullable String metaData, int width, int height, int radius, int iterations, boolean isPreView) {
    }
}

