/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.service.image.decoder;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import com.facebook.cache.common.CacheKey;
import com.facebook.cache.common.MultiCacheKey;
import com.facebook.cache.common.SimpleCacheKey;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.bitmaps.PlatformBitmapFactory;
import com.facebook.imagepipeline.nativecode.Bitmaps;
import com.facebook.imagepipeline.request.BasePostprocessor;
import com.facebook.imagepipeline.request.Postprocessor;
import com.lynx.tasm.image.model.BitmapPostProcessor;
import java.util.LinkedList;
import java.util.List;

public class MultiPostProcessor
implements Postprocessor {
    private final List<BitmapPostProcessor> mPostprocessors;
    private Bitmap.Config mBitmapConfig;

    public MultiPostProcessor(List<BitmapPostProcessor> mPostprocessors, Bitmap.Config config) {
        this.mBitmapConfig = config;
        this.mPostprocessors = mPostprocessors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableReference<Bitmap> process(Bitmap sourceBitmap, PlatformBitmapFactory bitmapFactory) {
        CloseableReference prevBitmap = null;
        CloseableReference nextBitmap = null;
        try {
            for (BitmapPostProcessor p : this.mPostprocessors) {
                Bitmap.Config sourceBitmapConfig = this.mBitmapConfig != null ? this.mBitmapConfig : sourceBitmap.getConfig();
                nextBitmap = bitmapFactory.createBitmapInternal(sourceBitmap.getWidth(), sourceBitmap.getHeight(), sourceBitmapConfig != null ? sourceBitmapConfig : BasePostprocessor.FALLBACK_BITMAP_CONFIGURATION);
                if (((Bitmap)nextBitmap.get()).getConfig() == sourceBitmap.getConfig()) {
                    Bitmaps.copyBitmap((Bitmap)((Bitmap)nextBitmap.get()), (Bitmap)sourceBitmap);
                } else {
                    Canvas canvas = new Canvas((Bitmap)nextBitmap.get());
                    canvas.drawBitmap(sourceBitmap, 0.0f, 0.0f, null);
                }
                p.process(prevBitmap != null ? (Bitmap)prevBitmap.get() : sourceBitmap, (Bitmap)nextBitmap.get());
                CloseableReference.closeSafely(prevBitmap);
                prevBitmap = CloseableReference.cloneOrNull((CloseableReference)nextBitmap);
            }
            CloseableReference closeableReference = CloseableReference.cloneOrNull(nextBitmap);
            return closeableReference;
        }
        finally {
            CloseableReference.closeSafely(nextBitmap);
        }
    }

    public String getName() {
        StringBuilder name = new StringBuilder();
        for (BitmapPostProcessor p : this.mPostprocessors) {
            if (name.length() > 0) {
                name.append(",");
            }
            name.append(p.getName());
        }
        name.insert(0, "MultiPostProcessor (");
        name.append(")");
        return name.toString();
    }

    public CacheKey getPostprocessorCacheKey() {
        LinkedList<SimpleCacheKey> keys = new LinkedList<SimpleCacheKey>();
        for (BitmapPostProcessor p : this.mPostprocessors) {
            keys.push(new SimpleCacheKey(p.getPostprocessorCacheKey()));
        }
        return new MultiCacheKey(keys);
    }
}

