/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.service.image.utils;

import android.net.Uri;
import com.facebook.cache.common.CacheKey;
import com.facebook.common.references.CloseableReference;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.imagepipeline.cache.CacheKeyFactory;
import com.facebook.imagepipeline.cache.MemoryCache;
import com.facebook.imagepipeline.common.ImageDecodeOptionsBuilder;
import com.facebook.imagepipeline.common.Priority;
import com.facebook.imagepipeline.common.ResizeOptions;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.request.ImageRequestBuilder;
import com.facebook.imagepipeline.request.Postprocessor;
import com.lynx.service.image.decoder.MultiPostProcessor;
import com.lynx.tasm.image.model.ImageRequestInfo;

public class ImageUtils {
    private static CacheKeyFactory sCacheKeyFactory = null;

    public static ResizeOptions getResizeOptions(int width, int height, int lastWidth, int lastHeight) {
        if (lastWidth <= 0 || lastHeight <= 0 || Math.abs(width - lastWidth) > 1 || Math.abs(height - lastHeight) > 1) {
            return new ResizeOptions(width, height);
        }
        return new ResizeOptions(lastWidth, lastHeight);
    }

    public static ImageRequest getFrescoImageRequest(ImageRequestInfo imageRequestInfo) {
        ImageRequestBuilder builder = ImageRequestBuilder.newBuilderWithSource((Uri)Uri.parse((String)imageRequestInfo.getUrl()));
        ImageDecodeOptionsBuilder decodeOptionsBuilder = new ImageDecodeOptionsBuilder();
        if (imageRequestInfo.getConfig() != null) {
            decodeOptionsBuilder.setBitmapConfig(imageRequestInfo.getConfig());
        }
        builder.setAutoRotateEnabled(true).setProgressiveRenderingEnabled(false);
        if (!imageRequestInfo.isEnableResourceHint()) {
            ResizeOptions resizeOptions;
            ResizeOptions resizeOptions2 = resizeOptions = imageRequestInfo.isEnableDownSampling() ? new ResizeOptions(imageRequestInfo.getResizeWidth(), imageRequestInfo.getResizeHeight()) : null;
            if (resizeOptions != null) {
                builder.setResizeOptions(resizeOptions);
            }
        }
        if (imageRequestInfo.getDiskCacheChoice() != null && 1 == imageRequestInfo.getDiskCacheChoice()) {
            builder.setCacheChoice(ImageRequest.CacheChoice.SMALL);
        }
        if (imageRequestInfo.isEnableAsyncRequest()) {
            builder.setRequestPriority(Priority.HIGH);
        }
        if (imageRequestInfo.getProcessors() != null && !imageRequestInfo.getProcessors().isEmpty()) {
            MultiPostProcessor postProcessor = new MultiPostProcessor(imageRequestInfo.getProcessors(), imageRequestInfo.getConfig());
            builder.setPostprocessor((Postprocessor)postProcessor);
        }
        return builder.build();
    }

    public static CloseableReference<CloseableImage> getCachedImage(MemoryCache<CacheKey, CloseableImage> memoryCache, CacheKey cacheKey) {
        if (memoryCache == null || cacheKey == null) {
            return null;
        }
        CloseableReference closeableImage = memoryCache.get((Object)cacheKey);
        if (closeableImage != null && !((CloseableImage)closeableImage.get()).getQualityInfo().isOfFullQuality()) {
            closeableImage.close();
            return null;
        }
        return closeableImage;
    }

    public static CacheKey getCacheKey(ImageRequest imageRequest, Object callerContext) {
        CacheKey cacheKey = null;
        if (sCacheKeyFactory == null) {
            sCacheKeyFactory = Fresco.getImagePipeline().getCacheKeyFactory();
        }
        if (sCacheKeyFactory != null && imageRequest != null) {
            cacheKey = imageRequest.getPostprocessor() != null ? sCacheKeyFactory.getPostprocessedBitmapCacheKey(imageRequest, callerContext) : sCacheKeyFactory.getBitmapCacheKey(imageRequest, callerContext);
        }
        return cacheKey;
    }
}

