/*
 * Decompiled with CFR 0.152.
 */
package io.bestquality.protocol.mock;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MockConnectionRegistry {
    private static final Map<Pattern, URLConnection> connections = new LinkedHashMap<Pattern, URLConnection>();

    public static void installProtocolHandlers() {
        System.setProperty("java.protocol.handler.pkgs", "io.bestquality.protocol");
    }

    public static URLConnection findMockConnection(URL url) throws IOException {
        String externalForm = url.toExternalForm();
        return (URLConnection)connections.entrySet().stream().filter(entry -> {
            Pattern pattern = (Pattern)entry.getKey();
            Matcher matcher = pattern.matcher(externalForm);
            return matcher.matches();
        }).findFirst().orElseThrow(() -> new IOException(String.format("Missing mock URLConnection for %s", externalForm))).getValue();
    }

    public static void registerMockConnection(Pattern pattern, URLConnection connection) {
        connections.put(pattern, connection);
    }

    public static void registerMockConnection(URLConnection connection) {
        MockConnectionRegistry.registerMockConnection(Pattern.compile(".*"), connection);
    }

    public static void clearMockConnections() {
        connections.clear();
    }
}

