/*
 * Decompiled with CFR 0.152.
 */
package tools.stio;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

public class Stio {
    private static HashMap<String, TypeAdapter> adapterByType = new HashMap();
    private TypeAdapter stioTypeAdapter = new TypeAdapter(){

        @Override
        public void writeStruct(Object obj, IOutputDriver driver) {
        }

        @Override
        public Object readStruct(String type, IInputDriver driver) {
            return null;
        }

        @Override
        public void objectByType(String type, String[] tags) {
        }
    };

    public TypeAdapter adapterForType(String type) {
        return null;
    }

    public static TypeAdapter adapter(Object obj) {
        return null;
    }

    public void setTypeAdapter(Class clazz, String type, TypeAdapter adapter) {
    }

    public static Object newInstance(Class ofClass) throws InstantiationException {
        Exception lastException;
        String lastMessage = null;
        try {
            Object result = ofClass.newInstance();
            return result;
        }
        catch (IllegalAccessException e) {
            lastMessage = "Default constructor is not accessible for " + Stio.getClassName(ofClass);
            lastException = e;
        }
        catch (Exception e) {
            lastMessage = null;
            lastException = e;
        }
        Constructor<?>[] constructors = ofClass.getDeclaredConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            Constructor<?> currentConstructor = constructors[i];
            currentConstructor.setAccessible(true);
            Class<?>[] argsTypes = currentConstructor.getParameterTypes();
            int argsNum = argsTypes.length;
            Object[] defaultArgs = new Object[argsNum];
            for (int j = 0; j < argsTypes.length; ++j) {
                Class<?> argType = argsTypes[j];
                if (!argType.isPrimitive()) continue;
                if (argType.equals(Boolean.TYPE)) {
                    defaultArgs[j] = Boolean.FALSE;
                    continue;
                }
                if (argType.equals(Integer.TYPE)) {
                    defaultArgs[j] = 0;
                    continue;
                }
                if (argType.equals(Short.TYPE)) {
                    defaultArgs[j] = (short)0;
                    continue;
                }
                if (argType.equals(Byte.TYPE)) {
                    defaultArgs[j] = (byte)0;
                    continue;
                }
                if (argType.equals(Float.TYPE)) {
                    defaultArgs[j] = Float.valueOf(0.0f);
                    continue;
                }
                if (!argType.equals(Double.TYPE)) continue;
                defaultArgs[j] = 0.0;
            }
            try {
                return currentConstructor.newInstance(defaultArgs);
            }
            catch (IllegalAccessException e) {
                lastMessage = "Constructor " + currentConstructor + " is not accessible for " + Stio.getClassName(ofClass);
                lastException = e;
                continue;
            }
            catch (InvocationTargetException e) {
                lastMessage = "Constructor " + currentConstructor + " has failed: " + e.getLocalizedMessage() + " (don't forget to check arguments for null in the constructor).";
                lastException = e;
                continue;
            }
            catch (Exception e) {
                lastMessage = null;
                lastException = e;
            }
        }
        InstantiationException resultException = lastMessage != null ? new InstantiationException(lastMessage) : new InstantiationException(lastMessage);
        resultException.initCause(lastException);
        throw resultException;
    }

    public static String getClassName(Object obj) {
        if (obj == null) {
            return null;
        }
        String fullClassName = obj instanceof Class ? ((Class)obj).getName() : (obj instanceof String ? (String)obj : obj.getClass().getName());
        return fullClassName.substring(fullClassName.lastIndexOf(46) + 1);
    }

    public static class JS {
        public Object node;
        Object currentNode = null;
        private int reads = 0;

        private void clearPath() {
            this.currentNode = this.node;
            this.reads = 0;
        }

        private void clearPathAfterReads() {
            if (this.reads > 0) {
                this.clearPath();
            }
        }

        public static JS from(String jsonStr) {
            if (jsonStr == null || jsonStr.length() == 0) {
                return new JS();
            }
            return new JS().from(JSONIn.parse(jsonStr));
        }

        public JS from(Object node) {
            this.node = node;
            this.currentNode = node;
            return this;
        }

        public JS at(String key) {
            this.clearPathAfterReads();
            if (this.currentNode != null) {
                this.currentNode = ((HashMap)this.currentNode).get(key);
            }
            return this;
        }

        public JS at(int at) {
            this.clearPathAfterReads();
            if (this.currentNode != null) {
                this.currentNode = ((List)this.currentNode).get(at);
            }
            return this;
        }

        public Boolean getBool(String key) {
            ++this.reads;
            if (this.currentNode == null) {
                return null;
            }
            Object value = ((HashMap)this.currentNode).get(key);
            return (Boolean)value;
        }

        public boolean getBool(String key, boolean defaultValue) {
            Boolean bool = this.getBool(key);
            if (bool == null) {
                return defaultValue;
            }
            return bool;
        }

        public Integer getInt(String key) {
            ++this.reads;
            if (this.currentNode == null) {
                return null;
            }
            Object value = ((HashMap)this.currentNode).get(key);
            if (value == null) {
                return null;
            }
            if (!String.class.isInstance(value)) {
                throw new IllegalArgumentException("Not an int value at: " + key + " : " + value);
            }
            return Integer.parseInt((String)value);
        }

        public int getInt(String key, int defaultValue) {
            Integer integer = this.getInt(key);
            return integer == null ? defaultValue : integer;
        }

        public String getString(String key) {
            ++this.reads;
            if (this.currentNode == null) {
                return null;
            }
            Object value = ((HashMap)this.currentNode).get(key);
            return (String)value;
        }

        public boolean has(String key) {
            if (this.currentNode == null) {
                return false;
            }
            return ((HashMap)this.currentNode).get(key) != null;
        }

        public boolean hasArr(String key) {
            if (this.currentNode == null) {
                return false;
            }
            Object value = ((HashMap)this.currentNode).get(key);
            return value != null && value instanceof List;
        }

        public int size() {
            this.clearPathAfterReads();
            if (this.currentNode == null) {
                return -1;
            }
            if (!(this.currentNode instanceof List)) {
                throw new IllegalStateException("Not an array!");
            }
            List arr = (List)this.currentNode;
            return arr.size();
        }

        public JS js() {
            JS result = new JS();
            result.from(this.currentNode);
            return result;
        }

        public String[] getStrings(String key) {
            ++this.reads;
            if (this.currentNode == null) {
                return null;
            }
            Object value = ((HashMap)this.currentNode).get(key);
            if (value == null) {
                return null;
            }
            List values = (List)value;
            String[] result = new String[values.size()];
            int i = 0;
            for (Object v : values) {
                result[i++] = (String)v;
            }
            return result;
        }
    }

    public static class OutputOnWriter
    extends Output {
        Writer writer;

        public OutputOnWriter(Writer on) {
            this.writer = on;
        }

        @Override
        public Output append(String str) {
            try {
                this.writer.write(str == null ? "null" : str);
            }
            catch (IOException e) {
                throw new IllegalStateException("Writer is broken", e);
            }
            return this;
        }

        @Override
        public Output append(char c) {
            try {
                this.writer.write(c);
            }
            catch (IOException e) {
                throw new IllegalStateException("Writer is broken", e);
            }
            return this;
        }

        @Override
        public Output flush() {
            try {
                this.writer.flush();
            }
            catch (IOException e) {
                throw new IllegalStateException("Writer is broken", e);
            }
            return this;
        }
    }

    public static class OutputOnBuilder
    extends Output {
        StringBuilder sb;

        public OutputOnBuilder(StringBuilder sb) {
            this.sb = sb;
        }

        public OutputOnBuilder() {
            this.sb = new StringBuilder();
        }

        @Override
        public OutputOnBuilder append(String str) {
            this.sb.append(str);
            return this;
        }

        @Override
        public OutputOnBuilder append(char c) {
            this.sb.append(c);
            return this;
        }

        public String toString() {
            return this.sb.toString();
        }

        @Override
        public Output flush() {
            return this;
        }
    }

    public static abstract class Output {
        public abstract Output append(String var1);

        public abstract Output append(char var1);

        public abstract Output flush();
    }

    public static class JSONOut
    implements IOutputDriver {
        private static String quoteChar = "\"";
        private Output output = new OutputOnBuilder(new StringBuilder());
        protected ArrayList<Tag> stack = new ArrayList();

        public static Output escape(String what, Output to) {
            block9: for (int i = 0; i < what.length(); ++i) {
                char ch = what.charAt(i);
                switch (ch) {
                    case '\"': {
                        to.append("\\").append("\"");
                        continue block9;
                    }
                    case '\\': {
                        to.append("\\").append("\\");
                        continue block9;
                    }
                    case '\b': {
                        to.append("\\").append("b");
                        continue block9;
                    }
                    case '\f': {
                        to.append("\\").append("f");
                        continue block9;
                    }
                    case '\n': {
                        to.append("\\").append("n");
                        continue block9;
                    }
                    case '\r': {
                        to.append("\\").append("r");
                        continue block9;
                    }
                    case '\t': {
                        to.append("\\").append("t");
                        continue block9;
                    }
                    default: {
                        if (ch >= '\u0000' && ch <= '\u001f') {
                            to.append(String.format("\\u%04x", ch));
                            continue block9;
                        }
                        if (Character.isHighSurrogate(ch)) {
                            to.append(String.format("\\u%04x", ch));
                            ch = what.charAt(++i);
                            if (ch == '\uffff') {
                                throw new IllegalArgumentException("Surrogate suquence must consist of 2 chars");
                            }
                            to.append(String.format("\\u%04x", ch));
                            continue block9;
                        }
                        to.append(ch);
                    }
                }
            }
            return to;
        }

        public JSONOut() {
            this(new OutputOnBuilder(new StringBuilder()));
        }

        public JSONOut(Writer writer) {
            this(new OutputOnWriter(writer));
        }

        public JSONOut(Output output) {
            this.output = output;
            Tag root = new Tag();
            this.stack.add(root);
        }

        public JSONOut tag() {
            if (this.stack.size() < 1) {
                throw new IllegalStateException("There is no opened root. Cannot accomodate tag or array.");
            }
            Tag current = this.stack.get(this.stack.size() - 1);
            if (!current.array) {
                throw new IllegalStateException("Unnamed block allowed only within arrays. current: " + current.name);
            }
            return this.tag(null);
        }

        public JSONOut arr() {
            if (this.stack.size() < 1) {
                throw new IllegalStateException("There is no opened root. Cannot accomodate tag or array.");
            }
            Tag current = this.stack.get(this.stack.size() - 1);
            if (!current.array) {
                throw new IllegalStateException("Unnamed block allowed only within arrays. current: " + current.name);
            }
            return this.tagImpl(null, true);
        }

        public JSONOut tag(String name) {
            if (this.stack.size() < 1) {
                throw new IllegalStateException("There is no opened root. Cannot accomodate tag or array.");
            }
            return this.tagImpl(name, false);
        }

        public JSONOut arr(String name) {
            if (this.stack.size() < 1) {
                throw new IllegalStateException("There is no opened root. Cannot accomodate tag or array.");
            }
            return this.tagImpl(name, true);
        }

        private JSONOut tagImpl(String name, boolean array) {
            Tag current = this.stack.get(this.stack.size() - 1);
            Tag tag = new Tag();
            tag.name = name;
            tag.array = array;
            this.stack.add(tag);
            this.openTag(tag, current);
            return this;
        }

        public JSONOut value(String value) {
            if (this.stack.size() < 2) {
                throw new IllegalStateException("There is no tag or array opened to accomodate the value");
            }
            if (value == null) {
                return this.value(null, false);
            }
            return this.value(value, true);
        }

        protected JSONOut value(String value, boolean escape) {
            Tag current = this.stack.get(this.stack.size() - 1);
            Tag parent = this.stack.get(this.stack.size() - 2);
            if (current.array) {
                if (current.subs > 0) {
                    this.output.append(",");
                }
                if (escape) {
                    this.output.append(quoteChar);
                    JSONOut.escape(value, this.output);
                    this.output.append(quoteChar);
                } else {
                    this.output.append(value);
                }
                ++current.subs;
            } else {
                if (escape) {
                    this.output.append(quoteChar);
                    JSONOut.escape(value, this.output);
                    this.output.append(quoteChar);
                } else {
                    this.output.append(value);
                }
                if (parent.array) {
                    this.output.append("}");
                }
                ++parent.subs;
                this.stack.remove(this.stack.size() - 1);
            }
            return this;
        }

        private void openTag(Tag current, Tag parent) {
            if (parent.subs > 0) {
                this.output.append(",");
            }
            if (parent.array) {
                if (current.name == null) {
                    if (current.array) {
                        this.output.append("[");
                    }
                } else {
                    this.output.append("{");
                    this.output.append(quoteChar);
                    JSONOut.escape(current.name, this.output);
                    this.output.append(quoteChar);
                    this.output.append(":");
                    if (current.array) {
                        this.output.append("[");
                    }
                }
            } else {
                if (current.name == null) {
                    throw new IllegalStateException("Only array can have noname blocks");
                }
                if (parent.subs == 0) {
                    this.output.append("{");
                }
                this.output.append(quoteChar);
                JSONOut.escape(current.name, this.output);
                this.output.append(quoteChar);
                this.output.append(":");
                if (current.array) {
                    this.output.append("[");
                }
            }
        }

        public JSONOut end() {
            if (this.stack.size() == 0) {
                throw new IllegalStateException("There is no tag remaining opened");
            }
            if (this.stack.size() == 1) {
                this.output.append(this.stack.get((int)0).subs == 0 ? "{}" : "}");
                this.stack.remove(this.stack.size() - 1);
                return this;
            }
            Tag tag = this.stack.get(this.stack.size() - 1);
            Tag parent = this.stack.get(this.stack.size() - 2);
            if (tag.array) {
                this.output.append("]");
                if (parent.array && tag.name != null) {
                    this.output.append("}");
                }
            } else if (tag.name != null && tag.subs == 0) {
                this.output.append("null");
                if (parent.array && tag.name != null) {
                    this.output.append("}");
                }
            } else {
                this.output.append("}");
            }
            ++parent.subs;
            this.stack.remove(this.stack.size() - 1);
            return this;
        }

        public String toString() {
            if (!(this.output instanceof OutputOnBuilder)) {
                return "[JSONOut stack: " + this.stack.size() + "]";
            }
            if (this.stack.size() == 1 && this.stack.get((int)0).subs == 0) {
                return "{}";
            }
            StringBuilder sb = ((OutputOnBuilder)this.output).sb;
            int savedLength = sb.length();
            for (int i = this.stack.size() - 1; i >= 0; --i) {
                Tag tag = this.stack.get(i);
                if (tag.array) {
                    this.output.append("]");
                    continue;
                }
                if (i == this.stack.size() - 1 && tag.name != null && tag.subs == 0) {
                    this.output.append("null");
                    continue;
                }
                this.output.append("}");
            }
            String result = this.output.toString();
            sb.setLength(savedLength);
            return result;
        }

        public void flush() {
            for (int i = this.stack.size() - 1; i >= 0; --i) {
                this.end();
            }
            this.output.flush();
        }

        public JSONOut tag(String name, String value) {
            return this.tag(name).value(value);
        }

        public JSONOut tag(String name, int value) {
            return this.tag(name).value(String.valueOf(value), false);
        }

        public JSONOut tag(String name, double value) {
            return this.tag(name).value(String.valueOf(value), false);
        }

        public JSONOut tag(String name, boolean value) {
            return this.tag(name).value(String.valueOf(value), false);
        }

        @Override
        public void writeBool(Boolean value, String tag) {
            if (value == null) {
                return;
            }
            this.tag(tag).value(value != false ? "true" : "false", false);
        }

        @Override
        public void writeShort(Short value, String tag) {
            if (value == null) {
                return;
            }
            this.tag(tag).value(value.toString(), false);
        }

        @Override
        public void writeInt(Integer value, String tag) {
            if (value == null) {
                return;
            }
            this.tag(tag).value(value.toString(), false);
        }

        @Override
        public void writeLong(Long value, String tag) {
            if (value == null) {
                return;
            }
            this.tag(tag).value(value.toString(), false);
        }

        @Override
        public void writeFloat(Float value, String tag) {
            if (value == null) {
                return;
            }
            this.tag(tag).value(value.toString(), false);
        }

        @Override
        public void writeDouble(Double value, String tag) {
            if (value == null) {
                return;
            }
            this.tag(tag).value(value.toString(), false);
        }

        @Override
        public void writeString(String value, String tag) {
            if (value == null) {
                return;
            }
            this.tag(tag, value);
        }

        @Override
        public void writeObject(Object value, String tag) {
            if (value == null) {
                return;
            }
            this.tag(tag);
            this.writeObjectInner(value);
            this.end();
        }

        private void writeObjectInner(Object value) {
            this.tag("#type").value(value.getClass().getName());
            if (value instanceof Structured) {
                Structured sValue = (Structured)value;
                sValue.writeObject(this);
            } else {
                TypeAdapter adapter = Stio.adapter(value);
                if (adapter != null) {
                    adapter.writeStruct(value, this);
                }
            }
        }

        @Override
        public void writeBools(boolean[] value, String tag) {
            if (value == null) {
                return;
            }
            this.arr(tag);
            for (int i = 0; i < value.length; ++i) {
                this.value(value[i] ? "true" : "false", false);
            }
            this.end();
        }

        @Override
        public void writeBytes(byte[] value, String tag) {
            if (value == null) {
                return;
            }
            this.arr(tag);
            for (int i = 0; i < value.length; ++i) {
                this.value(Byte.toString(value[i]), false);
            }
            this.end();
        }

        @Override
        public void writeShorts(short[] value, String tag) {
            if (value == null) {
                return;
            }
            this.arr(tag);
            for (int i = 0; i < value.length; ++i) {
                this.value(Short.toString(value[i]), false);
            }
            this.end();
        }

        @Override
        public void writeInts(int[] value, String tag) {
            if (value == null) {
                return;
            }
            this.arr(tag);
            for (int i = 0; i < value.length; ++i) {
                this.value(Integer.toString(value[i]), false);
            }
            this.end();
        }

        @Override
        public void writeLongs(long[] value, String tag) {
            if (value == null) {
                return;
            }
            this.arr(tag);
            for (int i = 0; i < value.length; ++i) {
                this.value(Long.toString(value[i]), false);
            }
            this.end();
        }

        @Override
        public void writeFloats(float[] value, String tag) {
            if (value == null) {
                return;
            }
            this.arr(tag);
            for (int i = 0; i < value.length; ++i) {
                this.value(Float.toString(value[i]), false);
            }
            this.end();
        }

        @Override
        public void writeDoubles(double[] value, String tag) {
            if (value == null) {
                return;
            }
            this.arr(tag);
            for (int i = 0; i < value.length; ++i) {
                this.value(Double.toString(value[i]), false);
            }
            this.end();
        }

        @Override
        public void writeStrings(String[] value, String tag) {
            if (value == null) {
                return;
            }
            this.arr(tag);
            for (int i = 0; i < value.length; ++i) {
                this.value(value[i]);
            }
            this.end();
        }

        @Override
        public void writeObjects(Object[] value, String tag) {
            if (value == null) {
                return;
            }
            this.arr(tag);
            for (int i = 0; i < value.length; ++i) {
                this.tag();
                this.writeObjectInner(value[i]);
                this.end();
            }
            this.end();
        }

        private static class Tag {
            String name;
            int subs;
            boolean array;

            private Tag() {
            }

            public String toString() {
                return this.name + (this.array ? "[" : "{") + this.subs + (this.array ? "]" : "}");
            }
        }
    }

    public static class JSONIn
    implements IInputDriver {
        Reader input;
        private int lineNo = 0;
        private int symbolNo = 0;
        private char symbol = '\u0000';
        private static final String VALUE_NONQUOTED = "tfn1234567890-";
        private static final String SPACES = " \t\n";
        private static final String ARRAY_ITEM_START = "\"[{";
        private static final String ARRAY_ITEM_START_ALL = "\"[{tfn1234567890-";
        private static final String VALUE_START = "\"[{";
        private static final String VALUE_END = " \t\n,]}";
        private static final String VALUE_ALL = "\"[{tfn1234567890-";
        private static final Object NULL = new Object();
        char[] uniBuffer = new char[4];
        ArrayList<HashMap<String, Object>> nodeStack = new ArrayList();
        private static final Structured[] EMPTY_OBJECTS = new Structured[0];

        public JSONIn(String jsonStr) {
            this(new StringReader(jsonStr));
        }

        public JSONIn(Reader reader) {
            this.input = reader;
        }

        public static HashMap<String, Object> parse(String input) {
            return JSONIn.parse(new StringReader(input));
        }

        public static HashMap<String, Object> parse(Reader reader) {
            try {
                HashMap<String, Object> result = new JSONIn(reader).root();
                reader.close();
                return result;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Uhhh... something wrong with input: " + e.getMessage(), e);
            }
        }

        protected HashMap<String, Object> root() throws IOException {
            try {
                this.skip(SPACES, "{", this.input);
                return this.parseNode(this.input);
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Exception e) {
                throw new IOException("Something terrible...  at line: " + (this.lineNo + 1) + ", char: " + (this.symbolNo + 1), e);
            }
        }

        HashMap<String, Object> parseNode(Reader reader) throws IOException {
            Object[] tmp = new Object[1];
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            int ch = this.skip(SPACES, "\"}", reader);
            if (ch == 125) {
                return result;
            }
            while (ch != -1) {
                String key = this.parseQuoted(reader);
                ch = this.skip(SPACES, ":", reader);
                ch = this.skip(SPACES, "\"[{tfn1234567890-", reader);
                switch (ch) {
                    case 34: {
                        Object value = this.parseQuoted(reader);
                        result.put(key, value);
                        ch = this.skip(SPACES, ",}", reader);
                        break;
                    }
                    case 123: {
                        Object value = this.parseNode(reader);
                        result.put(key, value);
                        ch = this.skip(SPACES, ",}", reader);
                        break;
                    }
                    case 91: {
                        Object value = this.parseArray(reader);
                        result.put(key, value);
                        ch = this.skip(SPACES, ",}", reader);
                        break;
                    }
                    default: {
                        Object value;
                        ch = this.parseNonQuoted(ch, reader, ",} ", tmp);
                        if (ch == 32) {
                            ch = this.skip(SPACES, ",}", reader);
                        }
                        if (tmp[0] != null) {
                            value = tmp[0];
                            result.put(key, value == NULL ? null : value);
                            tmp[0] = null;
                            break;
                        }
                        throw this.unexpected(ch, ",}");
                    }
                }
                if (ch == 125) break;
                ch = this.skip(SPACES, "\"", reader);
            }
            if (ch != 125) {
                throw this.unexpected(ch, "}");
            }
            return result;
        }

        ArrayList parseArray(Reader reader) throws IOException {
            Object[] tmp = new Object[1];
            ArrayList<Object> results = new ArrayList<Object>();
            int ch = this.skip(SPACES, reader);
            while (ch != -1) {
                switch (ch) {
                    case 34: {
                        results.add(this.parseQuoted(reader));
                        ch = this.skip(SPACES, ",]", reader);
                        break;
                    }
                    case 123: {
                        results.add(this.parseNode(reader));
                        ch = this.skip(SPACES, ",]", reader);
                        break;
                    }
                    case 91: {
                        results.add(this.parseArray(reader));
                        ch = this.skip(SPACES, ",]", reader);
                        break;
                    }
                    case 93: {
                        break;
                    }
                    default: {
                        ch = this.parseNonQuoted(ch, reader, ",]", tmp);
                        if (tmp[0] != null) {
                            results.add(tmp[0] == NULL ? null : tmp[0]);
                            tmp[0] = null;
                            break;
                        }
                        throw this.unexpected(ch, "\"{[");
                    }
                }
                if (ch == 93) break;
                ch = this.skip(SPACES, "\"[{tfn1234567890-", reader);
            }
            if (ch != 93) {
                throw this.unexpected(ch, "]");
            }
            return results;
        }

        String parseQuoted(Reader input) throws IOException {
            StringBuilder result = new StringBuilder();
            this.parseQuoted(input, result);
            return result.toString();
        }

        void parseQuoted(Reader input, StringBuilder sb) throws IOException {
            int ch;
            while ((ch = input.read()) != -1) {
                this.count(ch);
                if (ch == 92) {
                    ch = (char)input.read();
                    switch (ch) {
                        case 34: {
                            sb.append("\"");
                            break;
                        }
                        case 92: {
                            sb.append("\\");
                            break;
                        }
                        case 47: {
                            sb.append("/");
                            break;
                        }
                        case 98: {
                            sb.append('\b');
                            break;
                        }
                        case 102: {
                            sb.append('\f');
                            break;
                        }
                        case 110: {
                            sb.append('\n');
                            break;
                        }
                        case 114: {
                            sb.append('\r');
                            break;
                        }
                        case 116: {
                            sb.append('\t');
                            break;
                        }
                        case 117: {
                            sb.append(this.parseUnicode(input));
                        }
                    }
                    continue;
                }
                if (ch == 34) {
                    return;
                }
                sb.append((char)ch);
            }
        }

        char parseUnicode(Reader input) throws IOException {
            int read = input.read(this.uniBuffer);
            if (read < 0) {
                throw new IOException("Nothing to read? Expected Unicode 4 digits, but read only " + read);
            }
            char uniChar = (char)Integer.valueOf(new String(this.uniBuffer, 0, 4), 16).intValue();
            this.count(this.uniBuffer[0]);
            this.count(this.uniBuffer[1]);
            this.count(this.uniBuffer[2]);
            this.count(this.uniBuffer[3]);
            return uniChar;
        }

        private int parseNonQuoted(int ch, Reader reader, String stopSymbols, Object[] to) throws IOException {
            switch (ch) {
                case 102: {
                    this.readStrict("alse", reader);
                    to[0] = Boolean.FALSE;
                    return this.skip(SPACES, stopSymbols, reader);
                }
                case 116: {
                    this.readStrict("rue", reader);
                    to[0] = Boolean.TRUE;
                    return this.skip(SPACES, stopSymbols, reader);
                }
                case 110: {
                    this.readStrict("ull", reader);
                    to[0] = NULL;
                    return this.skip(SPACES, stopSymbols, reader);
                }
                case 45: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    StringBuilder sb = new StringBuilder().append((char)ch);
                    int lastChar = this.read(sb, reader, stopSymbols);
                    to[0] = sb.toString();
                    return lastChar;
                }
            }
            if (JSONIn.isStop(ch, stopSymbols)) {
                return ch;
            }
            throw this.unexpected(ch, stopSymbols);
        }

        private char readStrict(String word, Reader reader) throws IOException {
            for (int i = 0; i < word.length(); ++i) {
                int ch = reader.read();
                this.count(ch);
                if (ch == word.charAt(i)) continue;
                throw this.unexpected(ch, "" + word.charAt(i), " of required word: " + word + ", at: " + i);
            }
            return word.charAt(word.length() - 1);
        }

        private String readDecimal(StringBuilder collector, Reader reader) throws IOException {
            int ch;
            boolean decimal = false;
            while ((ch = reader.read()) != -1) {
                this.count(ch);
                if (ch < 48 && ch > 57) {
                    if (ch == 46) {
                        decimal = true;
                    } else {
                        throw this.unexpected(ch, "0-9 or .");
                    }
                }
                collector.append((char)ch);
            }
            return collector.toString();
        }

        private static boolean isEqual(String str, StringBuilder sb) {
            if (str.length() != sb.length()) {
                return false;
            }
            for (int i = 0; i < str.length(); ++i) {
                if (str.charAt(i) == sb.charAt(i)) continue;
                return false;
            }
            return true;
        }

        private int read(StringBuilder to, Reader reader, String stopSymbols) throws IOException {
            return this.read(to, reader, stopSymbols, -1);
        }

        private int read(StringBuilder to, Reader reader, String stopSymbols, int count) throws IOException {
            if (count == 0) {
                throw new IllegalArgumentException("Read " + count + " chars? No read no call");
            }
            int ch = -1;
            int charsRead = 0;
            while ((ch = reader.read()) != -1) {
                this.count(ch);
                if (count != -1 && ++charsRead == count) {
                    return ch;
                }
                if (JSONIn.isStop(ch, stopSymbols)) {
                    return ch;
                }
                to.append((char)ch);
            }
            throw new IOException("Nothing to read, charsRead: " + charsRead + ", readCount: " + count + ", stopSymbols: " + stopSymbols);
        }

        private int skip(String skipSymbols, Reader reader) throws IOException {
            return this.skip(skipSymbols, null, reader);
        }

        private int skip(String skipSymbols, String stopSymbols, Reader reader) throws IOException {
            int n;
            int n2 = -1;
            boolean skip = false;
            while ((n = reader.read()) != -1) {
                this.count(n);
                if (JSONIn.isStop(n, stopSymbols)) {
                    return n;
                }
                skip = false;
                for (int i = 0; i < skipSymbols.length(); ++i) {
                    if (n != skipSymbols.charAt(i)) continue;
                    skip = true;
                    break;
                }
                if (skip) continue;
                if (stopSymbols == null) {
                    return n;
                }
                throw this.unexpected(n, stopSymbols);
            }
            return n;
        }

        private void count(int ch) {
            this.symbol = (char)ch;
            if (ch == 10) {
                ++this.lineNo;
                this.symbolNo = 0;
            } else {
                ++this.symbolNo;
            }
        }

        private static boolean isStop(int ch, String stopSymbols) {
            if (stopSymbols == null) {
                return false;
            }
            for (int i = 0; i < stopSymbols.length(); ++i) {
                if (ch != stopSymbols.charAt(i)) continue;
                return true;
            }
            return false;
        }

        private IOException unexpected(int ch, String stopSymbols, String description) {
            return new IOException("Unexpected symbol: '" + (char)ch + "' at: " + this.symbolNo + " line: " + (this.lineNo + 1) + (stopSymbols != null ? " expected: " + JSONIn.toString(stopSymbols) : "") + (description != null ? " " + description : ""));
        }

        private IOException unexpected(int ch, String stopSymbols) {
            return this.unexpected(ch, stopSymbols, null);
        }

        private static String toString(String symbols) {
            if (symbols == null || symbols.length() == 0) {
                return "none";
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < symbols.length(); ++i) {
                sb.append(i > 0 ? "," : "");
                sb.append("'").append(symbols.charAt(i)).append("'");
            }
            return sb.toString();
        }

        public JSONIn root(HashMap<String, Object> root) {
            this.nodeStack.clear();
            this.nodeStack.add(root);
            return this;
        }

        private HashMap<String, Object> currentNode() {
            if (this.nodeStack.size() == 0) {
                return null;
            }
            return this.nodeStack.get(this.nodeStack.size() - 1);
        }

        private void checkParsed() {
            if (this.currentNode() == null) {
                try {
                    HashMap<String, Object> root = this.root();
                    this.nodeStack.add(root);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Input data is invalid", e);
                }
            }
        }

        @Override
        public Boolean readBool(String tag) {
            this.checkParsed();
            Object value = this.currentNode().get(tag);
            return JSONIn.readBoolInner(value, tag);
        }

        private static Boolean readBoolInner(Object value, String tag) {
            if (value == null) {
                return null;
            }
            if (Boolean.class.isInstance(value)) {
                return (Boolean)value;
            }
            if (!String.class.isInstance(value)) {
                throw new IllegalArgumentException("not a boolean: " + value + ", tag: " + tag);
            }
            if ("true".equals(value)) {
                return Boolean.TRUE;
            }
            if ("false".equals(value)) {
                return Boolean.FALSE;
            }
            throw new IllegalArgumentException("not a boolean value: " + value + ", at: " + tag);
        }

        @Override
        public Short readShort(String tag) {
            this.checkParsed();
            Object value = this.currentNode().get(tag);
            if (value == null) {
                return null;
            }
            return JSONIn.readShortInner(value, tag);
        }

        private static short readShortInner(Object value, String tag) {
            if (!String.class.isInstance(value)) {
                throw new IllegalArgumentException("not a short value: " + value + ", tag: " + tag);
            }
            try {
                return Short.parseShort((String)value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("not a short value: " + value + ", tag: " + tag, e);
            }
        }

        @Override
        public Integer readInt(String tag) {
            this.checkParsed();
            Object value = this.currentNode().get(tag);
            if (value == null) {
                return null;
            }
            return JSONIn.readIntInner(value, tag);
        }

        private static int readIntInner(Object value, String tag) {
            if (!String.class.isInstance(value)) {
                throw new IllegalArgumentException("not an int value: " + value + ", tag: " + tag);
            }
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("not an int value: " + value + ", tag: " + tag, e);
            }
        }

        @Override
        public Long readLong(String tag) {
            this.checkParsed();
            Object value = this.currentNode().get(tag);
            if (value == null) {
                return null;
            }
            return JSONIn.readLongInner(value, tag);
        }

        private static long readLongInner(Object value, String tag) {
            if (!String.class.isInstance(value)) {
                throw new IllegalArgumentException("not a long value: " + value + ", tag: " + tag);
            }
            try {
                return Long.parseLong((String)value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("not a long value: " + value + ", tag: " + tag, e);
            }
        }

        @Override
        public Float readFloat(String tag) {
            this.checkParsed();
            Object value = this.currentNode().get(tag);
            if (value == null) {
                return null;
            }
            return Float.valueOf(JSONIn.readFloatInner(value, tag));
        }

        private static float readFloatInner(Object value, String tag) {
            if (!String.class.isInstance(value)) {
                throw new IllegalArgumentException("not a float value: " + value + ", tag: " + tag);
            }
            try {
                return Float.parseFloat((String)value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("not a float value: " + value + ", tag: " + tag, e);
            }
        }

        @Override
        public Double readDouble(String tag) {
            this.checkParsed();
            Object value = this.currentNode().get(tag);
            if (value == null) {
                return null;
            }
            return JSONIn.readDoubleInner(value, tag);
        }

        private static double readDoubleInner(Object value, String tag) {
            if (!String.class.isInstance(value)) {
                throw new IllegalArgumentException("not a double value: " + value + ", tag: " + tag);
            }
            try {
                return Double.parseDouble((String)value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("not a double value: " + value + ", tag: " + tag, e);
            }
        }

        @Override
        public String readString(String tag) {
            this.checkParsed();
            Object value = this.currentNode().get(tag);
            if (value == null) {
                return null;
            }
            if (!String.class.isInstance(value)) {
                throw new IllegalArgumentException("not a string: " + value + ", tag: " + tag);
            }
            return (String)value;
        }

        @Override
        public boolean[] readBools(String tag) {
            this.checkParsed();
            Object value = this.currentNode().get(tag);
            if (value == null) {
                return null;
            }
            if (!(value instanceof ArrayList)) {
                throw new IllegalArgumentException("object is not an array, tag: " + tag);
            }
            ArrayList list = (ArrayList)value;
            boolean[] result = new boolean[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Boolean b = JSONIn.readBoolInner(list.get(i), String.valueOf(i));
                if (b == null) {
                    throw new IllegalArgumentException("not a boolean: " + list.get(i) + ", at: " + i);
                }
                result[i] = b;
            }
            return result;
        }

        @Override
        public short[] readShorts(String tag) {
            this.checkParsed();
            Object value = this.currentNode().get(tag);
            if (value == null) {
                return null;
            }
            if (!(value instanceof ArrayList)) {
                throw new IllegalArgumentException("object is not an array, tag: " + tag);
            }
            ArrayList list = (ArrayList)value;
            short[] result = new short[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                short b;
                result[i] = b = JSONIn.readShortInner(list.get(i), String.valueOf(i));
            }
            return result;
        }

        @Override
        public int[] readInts(String tag) {
            this.checkParsed();
            Object value = this.currentNode().get(tag);
            if (value == null) {
                return null;
            }
            if (!(value instanceof ArrayList)) {
                throw new IllegalArgumentException("object is not an array, tag: " + tag);
            }
            ArrayList list = (ArrayList)value;
            int[] result = new int[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                int b;
                result[i] = b = JSONIn.readIntInner(list.get(i), String.valueOf(i));
            }
            return result;
        }

        @Override
        public long[] readLongs(String tag) {
            this.checkParsed();
            Object value = this.currentNode().get(tag);
            if (value == null) {
                return null;
            }
            if (!(value instanceof ArrayList)) {
                throw new IllegalArgumentException("object is not an array, tag: " + tag);
            }
            ArrayList list = (ArrayList)value;
            long[] result = new long[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                long b;
                result[i] = b = JSONIn.readLongInner(list.get(i), String.valueOf(i));
            }
            return result;
        }

        @Override
        public float[] readFloats(String tag) {
            this.checkParsed();
            Object value = this.currentNode().get(tag);
            if (value == null) {
                return null;
            }
            if (!(value instanceof ArrayList)) {
                throw new IllegalArgumentException("object is not an array, tag: " + tag);
            }
            ArrayList list = (ArrayList)value;
            float[] result = new float[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                float b;
                result[i] = b = JSONIn.readFloatInner(list.get(i), String.valueOf(i));
            }
            return result;
        }

        @Override
        public double[] readDoubles(String tag) {
            this.checkParsed();
            Object value = this.currentNode().get(tag);
            if (value == null) {
                return null;
            }
            if (!(value instanceof ArrayList)) {
                throw new IllegalArgumentException("object is not an array, tag: " + tag);
            }
            ArrayList list = (ArrayList)value;
            double[] result = new double[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                double b;
                result[i] = b = JSONIn.readDoubleInner(list.get(i), String.valueOf(i));
            }
            return result;
        }

        @Override
        public byte[] readBytes(String tag) {
            this.checkParsed();
            Object value = this.currentNode().get(tag);
            if (value == null) {
                return null;
            }
            if (!(value instanceof ArrayList)) {
                throw new IllegalArgumentException("object is not an array, tag: " + tag);
            }
            ArrayList list = (ArrayList)value;
            byte[] result = new byte[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                byte b;
                if (list.get(i) == null) {
                    throw new IllegalArgumentException("not a byte value: " + list.get(i));
                }
                result[i] = b = Byte.parseByte((String)list.get(i));
            }
            return result;
        }

        @Override
        public String[] readStrings(String tag) {
            this.checkParsed();
            Object value = this.currentNode().get(tag);
            if (value == null) {
                return null;
            }
            ArrayList list = (ArrayList)value;
            String[] result = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                result[i] = (String)list.get(i);
            }
            return result;
        }

        @Override
        public Object readObject(String tag) {
            this.checkParsed();
            Object value = this.currentNode().get(tag);
            if (value == null) {
                return null;
            }
            return this.readObjectInner(value, tag);
        }

        private Object readObjectInner(Object value, String tag) {
            if (!HashMap.class.isInstance(value)) {
                throw new IllegalArgumentException("not an object: " + value + ", tag: " + tag);
            }
            HashMap values = (HashMap)value;
            Object typeValue = values.get("#type");
            if (!String.class.isInstance(typeValue)) {
                throw new IllegalArgumentException("object's #type is undefined: " + value + ", tag: " + tag);
            }
            String type = (String)typeValue;
            try {
                Class<?> objectClass = Class.forName(type);
                Object obj = Stio.newInstance(objectClass);
                if (!(obj instanceof Structured)) {
                    throw new IllegalArgumentException("object doesn't implement Structured: " + obj + ", tag: " + tag);
                }
                Structured structured = (Structured)obj;
                this.nodeStack.add(values);
                structured.readObject(this);
                this.nodeStack.remove(this.nodeStack.size() - 1);
                return structured;
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Cannot find class: " + type + ", tag: " + tag, e);
            }
            catch (InstantiationException e) {
                throw new IllegalStateException("Cannot instantiate class: " + type + ", tag: " + tag, e);
            }
        }

        @Override
        public Object[] readObjects(String tag) {
            return this.readObjects(tag, EMPTY_OBJECTS);
        }

        @Override
        public Object[] readObjects(String tag, Object[] to) {
            this.checkParsed();
            Object value = this.currentNode().get(tag);
            if (value == null) {
                return null;
            }
            if (!(value instanceof ArrayList)) {
                throw new IllegalArgumentException("not an array, tag: " + tag);
            }
            ArrayList list = (ArrayList)value;
            Object[] result = to;
            if (to.length < list.size()) {
                result = (Object[])Array.newInstance(to.getClass().getComponentType(), list.size());
            }
            for (int i = 0; i < list.size(); ++i) {
                Object item = list.get(i);
                if (item == null) {
                    result[i] = null;
                }
                result[i] = this.readObjectInner(item, String.valueOf(i));
            }
            return result;
        }
    }

    public static interface TypeAdapter {
        public void objectByType(String var1, String[] var2);

        public void writeStruct(Object var1, IOutputDriver var2);

        public Object readStruct(String var1, IInputDriver var2);
    }

    public static interface IInputDriver {
        public Boolean readBool(String var1);

        public Short readShort(String var1);

        public Integer readInt(String var1);

        public Long readLong(String var1);

        public Float readFloat(String var1);

        public Double readDouble(String var1);

        public String readString(String var1);

        public Object readObject(String var1);

        public boolean[] readBools(String var1);

        public short[] readShorts(String var1);

        public int[] readInts(String var1);

        public long[] readLongs(String var1);

        public float[] readFloats(String var1);

        public double[] readDoubles(String var1);

        public String[] readStrings(String var1);

        public Object[] readObjects(String var1);

        public Object[] readObjects(String var1, Object[] var2);

        public byte[] readBytes(String var1);
    }

    public static interface IOutputDriver {
        public void writeBool(Boolean var1, String var2);

        public void writeShort(Short var1, String var2);

        public void writeInt(Integer var1, String var2);

        public void writeLong(Long var1, String var2);

        public void writeFloat(Float var1, String var2);

        public void writeDouble(Double var1, String var2);

        public void writeString(String var1, String var2);

        public void writeObject(Object var1, String var2);

        public void writeBools(boolean[] var1, String var2);

        public void writeShorts(short[] var1, String var2);

        public void writeInts(int[] var1, String var2);

        public void writeLongs(long[] var1, String var2);

        public void writeFloats(float[] var1, String var2);

        public void writeDoubles(double[] var1, String var2);

        public void writeStrings(String[] var1, String var2);

        public void writeObjects(Object[] var1, String var2);

        public void writeBytes(byte[] var1, String var2);
    }

    public static interface Structured {
        public void writeObject(IOutputDriver var1);

        public void readObject(IInputDriver var1);
    }
}

