/*
 * Decompiled with CFR 0.152.
 */
package enterprises.iwakura.ganyu;

import enterprises.iwakura.ganyu.CommandArgumentDefinition;
import enterprises.iwakura.ganyu.CommandResult;
import enterprises.iwakura.ganyu.Ganyu;
import enterprises.iwakura.ganyu.RegisteredCommand;
import enterprises.iwakura.ganyu.annotation.InjectableArgument;
import enterprises.iwakura.ganyu.annotation.NamedArg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@InjectableArgument
public class CommandInvocationContext {
    private final Ganyu ganyu;
    private final RegisteredCommand registeredCommand;
    private String unprocessedArguments = "";
    private final Map<CommandArgumentDefinition, Object> argumentValues = new HashMap<CommandArgumentDefinition, Object>();
    private CommandResult commandResult;
    private Throwable commandException;

    public void addArgumentValue(CommandArgumentDefinition argumentDefinition, Object value) {
        this.argumentValues.put(argumentDefinition, value);
    }

    public List<CommandArgumentDefinition> getArgumentsByTypeOrName(Class<?> parameterType, NamedArg namedArg) {
        ArrayList<CommandArgumentDefinition> matchingArguments = new ArrayList<CommandArgumentDefinition>();
        if (namedArg == null) {
            for (CommandArgumentDefinition def : this.registeredCommand.getArgumentDefinitions()) {
                if (!def.getType().equals(parameterType)) continue;
                matchingArguments.add(def);
            }
        } else {
            for (CommandArgumentDefinition def : this.registeredCommand.getArgumentDefinitions()) {
                if (!def.getType().equals(parameterType) || !def.getName().equals(namedArg.value())) continue;
                matchingArguments.add(def);
            }
        }
        return matchingArguments;
    }

    public Object getArgumentValue(CommandArgumentDefinition commandArgumentDefinition) {
        return this.argumentValues.get(commandArgumentDefinition);
    }

    @Generated
    public Ganyu getGanyu() {
        return this.ganyu;
    }

    @Generated
    public RegisteredCommand getRegisteredCommand() {
        return this.registeredCommand;
    }

    @Generated
    public String getUnprocessedArguments() {
        return this.unprocessedArguments;
    }

    @Generated
    public Map<CommandArgumentDefinition, Object> getArgumentValues() {
        return this.argumentValues;
    }

    @Generated
    public CommandResult getCommandResult() {
        return this.commandResult;
    }

    @Generated
    public Throwable getCommandException() {
        return this.commandException;
    }

    @Generated
    public void setUnprocessedArguments(String unprocessedArguments) {
        this.unprocessedArguments = unprocessedArguments;
    }

    @Generated
    public void setCommandResult(CommandResult commandResult) {
        this.commandResult = commandResult;
    }

    @Generated
    public void setCommandException(Throwable commandException) {
        this.commandException = commandException;
    }

    @Generated
    public CommandInvocationContext(Ganyu ganyu, RegisteredCommand registeredCommand) {
        this.ganyu = ganyu;
        this.registeredCommand = registeredCommand;
    }
}

