/*
 * Decompiled with CFR 0.152.
 */
package enterprises.iwakura.ganyu;

import enterprises.iwakura.ganyu.ArgumentParser;
import enterprises.iwakura.ganyu.CommandArgumentDefinition;
import enterprises.iwakura.ganyu.CommandArgumentParser;
import enterprises.iwakura.ganyu.CommandInvocationContext;
import enterprises.iwakura.ganyu.CommandRegisterProcessor;
import enterprises.iwakura.ganyu.CommandResult;
import enterprises.iwakura.ganyu.GanyuCommand;
import enterprises.iwakura.ganyu.InjectableArgumentResolver;
import enterprises.iwakura.ganyu.Input;
import enterprises.iwakura.ganyu.Output;
import enterprises.iwakura.ganyu.RegisteredCommand;
import enterprises.iwakura.ganyu.annotation.NamedArg;
import enterprises.iwakura.ganyu.exception.CommandParseException;
import enterprises.iwakura.ganyu.exception.InvalidCommandArgumentsException;
import enterprises.iwakura.ganyu.impl.ClassInjectableArgumentResolver;
import enterprises.iwakura.ganyu.impl.CommandArgumentParserImpl;
import enterprises.iwakura.ganyu.impl.CommandRegisterProcessorImpl;
import enterprises.iwakura.ganyu.impl.ConsoleInput;
import enterprises.iwakura.ganyu.impl.ConsoleOutput;
import enterprises.iwakura.ganyu.impl.argumentParsers.PrimitiveArgumentParsers;
import enterprises.iwakura.ganyu.impl.commands.HelpCommand;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import lombok.Generated;

public class Ganyu {
    protected final Input input;
    protected final Output output;
    protected final CommandArgumentParser commandArgumentParser;
    protected final CommandRegisterProcessor commandRegisterProcessor;
    protected final InjectableArgumentResolver injectableArgumentResolver;
    protected final Executor executor;
    protected final Map<String, RegisteredCommand> registeredCommandLookup = new TreeMap<String, RegisteredCommand>((a, b) -> {
        int cmp = Integer.compare(b.length(), a.length());
        return cmp != 0 ? cmp : a.compareTo((String)b);
    });
    protected ThreadFactory threadFactory = runnable -> new Thread(runnable, "Ganyu-Command-Reader");
    protected Map<Class<?>, ArgumentParser<?>> argumentParsers = new HashMap();
    protected List<RegisteredCommand> registeredCommands = new ArrayList<RegisteredCommand>();
    protected boolean run;
    protected final Thread commandReaderThread = this.createCommandReaderThread();

    public Ganyu(Input input, Output output, CommandArgumentParser commandArgumentParser, CommandRegisterProcessor commandRegisterProcessor, InjectableArgumentResolver injectableArgumentResolver, Executor executor) {
        this.input = input;
        this.output = output;
        this.commandArgumentParser = commandArgumentParser;
        this.commandRegisterProcessor = commandRegisterProcessor;
        this.injectableArgumentResolver = injectableArgumentResolver;
        this.executor = executor;
        PrimitiveArgumentParsers.register(this);
        this.registerCommands(new HelpCommand());
    }

    public static Ganyu console() {
        return Ganyu.standard(new ConsoleInput(), new ConsoleOutput());
    }

    public static Ganyu standard(Input input, Output output) {
        return new Ganyu(input, output, new CommandArgumentParserImpl(), new CommandRegisterProcessorImpl(), new ClassInjectableArgumentResolver(), Runnable::run);
    }

    public static Ganyu standardWithExecutor(Input input, Output output, Executor executor) {
        return new Ganyu(input, output, new CommandArgumentParserImpl(), new CommandRegisterProcessorImpl(), new ClassInjectableArgumentResolver(), executor);
    }

    public void run() {
        if (this.run) {
            throw new IllegalStateException("Ganyu is already running!");
        }
        this.run = true;
        this.commandReaderThread.start();
    }

    public void stop() {
        if (!this.run) {
            throw new IllegalStateException("Ganyu is not running!");
        }
        this.run = false;
        this.commandReaderThread.interrupt();
    }

    protected Thread createCommandReaderThread() {
        return this.threadFactory.newThread(() -> {
            while (this.run) {
                String inputString;
                try {
                    inputString = this.input.readNextInput();
                }
                catch (Exception exception) {
                    if (exception instanceof NoSuchElementException) {
                        return;
                    }
                    this.output.error("Failed to read input!", exception);
                    continue;
                }
                if (inputString == null || inputString.isEmpty()) continue;
                this.executor.execute(() -> {
                    RegisteredCommand registeredCommand = this.lookupCommand(inputString);
                    if (registeredCommand == null) {
                        this.output.error("Unknown command: " + inputString, null);
                        return;
                    }
                    CommandInvocationContext context = new CommandInvocationContext(this, registeredCommand);
                    try {
                        String arguments = inputString.replaceFirst(registeredCommand.getFullyQualifiedName(), "").trim();
                        context.setUnprocessedArguments(arguments);
                        if (registeredCommand.isNamedArgumentHandler()) {
                            this.commandArgumentParser.parseNamed(context);
                        } else {
                            this.commandArgumentParser.parseSimple(context);
                        }
                    }
                    catch (CommandParseException parseException) {
                        this.output.error(parseException.getMessage(), null);
                        this.handleException(context, parseException);
                        return;
                    }
                    catch (Exception exception) {
                        this.output.error("An unexpected error occurred while parsing command arguments!", exception);
                        this.handleException(context, exception);
                        return;
                    }
                    this.executeCommand(context);
                });
            }
        });
    }

    public <T> void registerArgumentParser(ArgumentParser<T> parser) {
        if (parser == null) {
            throw new IllegalArgumentException("Type and parser cannot be null!");
        }
        this.argumentParsers.put(parser.getType(), parser);
    }

    public List<RegisteredCommand> registerCommands(GanyuCommand ... commands) {
        if (commands == null || commands.length == 0) {
            return null;
        }
        List<RegisteredCommand> registeredCommands = null;
        for (GanyuCommand command : commands) {
            if (command == null) continue;
            registeredCommands = this.commandRegisterProcessor.process(this, command);
            this.registeredCommands.addAll(registeredCommands);
            registeredCommands.forEach(registeredCommand -> {
                if (registeredCommand.hasMethod()) {
                    this.registeredCommandLookup.put(registeredCommand.getFullyQualifiedName(), (RegisteredCommand)registeredCommand);
                }
                registeredCommand.getSubCommands().forEach(subCommand -> this.registeredCommandLookup.put(subCommand.getFullyQualifiedName(), (RegisteredCommand)subCommand));
            });
        }
        return registeredCommands;
    }

    protected RegisteredCommand lookupCommand(String inputString) {
        String[] splitInput = inputString.split(" ");
        for (int i = splitInput.length - 1; i >= 0; --i) {
            String constructedCommand = String.join((CharSequence)" ", Arrays.copyOfRange(splitInput, 0, i + 1));
            if (this.registeredCommandLookup.containsKey(constructedCommand)) {
                return this.registeredCommandLookup.get(constructedCommand);
            }
            if (i != 0) continue;
            return null;
        }
        return null;
    }

    protected void executeCommand(CommandInvocationContext ctx) {
        CompletableFuture futureCommandResult;
        Object commandReturnValue;
        RegisteredCommand command = ctx.getRegisteredCommand();
        if (command.getPreCommandMethod() != null) {
            try {
                command.getPreCommandMethod().invoke((Object)command.getGanyuCommand(), ctx);
            }
            catch (Exception exception) {
                this.output.error("An unexpected error occurred while invoking pre-command method!", exception);
                this.handleException(ctx, exception);
                return;
            }
        }
        try {
            commandReturnValue = command.getMethod().invoke((Object)command.getGanyuCommand(), this.getArgumentValues(command.getMethod(), ctx));
        }
        catch (Exception exception) {
            this.output.error("An unexpected error occurred while invoking/executing command method!", exception);
            this.handleException(ctx, exception);
            return;
        }
        if (commandReturnValue instanceof CommandResult) {
            futureCommandResult = CompletableFuture.completedFuture((CommandResult)commandReturnValue);
        } else if (commandReturnValue instanceof CompletableFuture) {
            try {
                futureCommandResult = (CompletableFuture)commandReturnValue;
            }
            catch (Exception exception) {
                this.output.error("An unexpected error occurred while casting command return value to CompletableFuture<CommandResult>!", exception);
                this.handleException(ctx, exception);
                return;
            }
        } else {
            futureCommandResult = CompletableFuture.completedFuture(CommandResult.success());
        }
        futureCommandResult.whenCompleteAsync((result, commandException) -> {
            ctx.setCommandException((Throwable)commandException);
            ctx.setCommandResult((CommandResult)result);
            if (commandException != null) {
                this.output.error("An unexpected error occurred while executing command!", (Throwable)commandException);
                this.handleException(ctx, (Exception)(commandException instanceof InvocationTargetException ? commandException.getCause() : commandException));
                return;
            }
            if (!result.isSuccess()) {
                if (result.getErrorMessage() != null) {
                    this.output.error(result.getErrorMessage(), null);
                } else {
                    this.output.error("Command execution failed (however, no message was given.)", null);
                }
            }
            if (command.getPostCommandMethod() != null) {
                try {
                    command.getPostCommandMethod().invoke((Object)command.getGanyuCommand(), ctx);
                }
                catch (Exception exception) {
                    this.output.error("An unexpected error occurred while invoking post-command method!", exception);
                    this.handleException(ctx, exception);
                }
            }
        });
    }

    protected void handleException(CommandInvocationContext ctx, Exception exceptionToHandle) {
        RegisteredCommand command = ctx.getRegisteredCommand();
        if (command.getExceptionHandlerMethod() != null) {
            try {
                command.getExceptionHandlerMethod().invoke((Object)command.getGanyuCommand(), ctx, exceptionToHandle);
            }
            catch (Exception exception) {
                this.output.error("An unexpected error occurred while invoking exception handler method!", exception);
            }
        }
    }

    protected Object[] getArgumentValues(Method method, CommandInvocationContext ctx) {
        int i;
        Parameter[] parameters = method.getParameters();
        Object[] arguments = new Object[method.getParameterCount()];
        for (i = 0; i < arguments.length; ++i) {
            int argumentIndex = i;
            Parameter parameter = parameters[argumentIndex];
            Class<?> parameterType = parameter.getType();
            List<CommandArgumentDefinition> argumentDefinitions = ctx.getArgumentsByTypeOrName(parameterType, parameter.getAnnotation(NamedArg.class));
            if (argumentDefinitions.isEmpty()) {
                throw new InvalidCommandArgumentsException(ctx, parameterType, argumentIndex);
            }
            if (argumentDefinitions.size() == 1) {
                arguments[argumentIndex] = ctx.getArgumentValue(argumentDefinitions.get(0));
                continue;
            }
            Optional<CommandArgumentDefinition> argumentDefinitionByIndex = argumentDefinitions.stream().filter(def -> def.getIndex() == argumentIndex).findFirst();
            if (!argumentDefinitionByIndex.isPresent()) {
                throw new InvalidCommandArgumentsException(ctx, parameterType, argumentIndex);
            }
            arguments[argumentIndex] = ctx.getArgumentValue(argumentDefinitionByIndex.get());
        }
        for (i = 0; i < parameters.length; ++i) {
            if (arguments[i] != null || !parameters[i].getType().isPrimitive()) continue;
            throw new InvalidCommandArgumentsException(ctx, parameters[i].getType(), i);
        }
        return arguments;
    }

    public List<RegisteredCommand> getRegisteredCommands() {
        return Collections.unmodifiableList(this.registeredCommands);
    }

    public ArgumentParser<?> getArgumentParser(Class<?> type) {
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be null!");
        }
        ArgumentParser<?> parser = this.argumentParsers.get(type);
        if (parser == null) {
            throw new IllegalArgumentException("No argument parser registered for type: " + type.getName());
        }
        return parser;
    }

    @Generated
    public Input getInput() {
        return this.input;
    }

    @Generated
    public Output getOutput() {
        return this.output;
    }

    @Generated
    public CommandArgumentParser getCommandArgumentParser() {
        return this.commandArgumentParser;
    }

    @Generated
    public CommandRegisterProcessor getCommandRegisterProcessor() {
        return this.commandRegisterProcessor;
    }

    @Generated
    public InjectableArgumentResolver getInjectableArgumentResolver() {
        return this.injectableArgumentResolver;
    }

    @Generated
    public Executor getExecutor() {
        return this.executor;
    }

    @Generated
    public Map<String, RegisteredCommand> getRegisteredCommandLookup() {
        return this.registeredCommandLookup;
    }

    @Generated
    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    @Generated
    public Map<Class<?>, ArgumentParser<?>> getArgumentParsers() {
        return this.argumentParsers;
    }

    @Generated
    public boolean isRun() {
        return this.run;
    }

    @Generated
    public Thread getCommandReaderThread() {
        return this.commandReaderThread;
    }

    @Generated
    public void setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    @Generated
    public void setArgumentParsers(Map<Class<?>, ArgumentParser<?>> argumentParsers) {
        this.argumentParsers = argumentParsers;
    }

    @Generated
    public void setRegisteredCommands(List<RegisteredCommand> registeredCommands) {
        this.registeredCommands = registeredCommands;
    }

    @Generated
    public void setRun(boolean run) {
        this.run = run;
    }
}

