/*
 * Decompiled with CFR 0.152.
 */
package enterprises.iwakura.ganyu.impl;

import enterprises.iwakura.ganyu.CommandArgumentDefinition;
import enterprises.iwakura.ganyu.CommandInvocationContext;
import enterprises.iwakura.ganyu.InjectableArgumentResolver;
import enterprises.iwakura.ganyu.annotation.InjectableArgument;
import java.util.Map;
import java.util.function.BiFunction;

public class ClassInjectableArgumentResolver
implements InjectableArgumentResolver {
    protected Map<Class<?>, BiFunction<CommandArgumentDefinition, CommandInvocationContext, Object>> resolvers;

    @Override
    public <T> void register(Class<T> clazz, BiFunction<CommandArgumentDefinition, CommandInvocationContext, T> resolverFunction) {
        if (!clazz.isAnnotationPresent(InjectableArgument.class)) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " is not annotated with @InjectableArgument");
        }
        this.resolvers.put(clazz, resolverFunction);
    }

    @Override
    public Object resolve(CommandArgumentDefinition commandArgumentDefinition, CommandInvocationContext ctx) {
        if (commandArgumentDefinition.getType() == CommandInvocationContext.class) {
            return ctx;
        }
        return this.resolvers.getOrDefault(commandArgumentDefinition.getType(), (def, ctx2) -> null);
    }
}

