/*
 * Decompiled with CFR 0.152.
 */
package enterprises.iwakura.ganyu.impl;

import enterprises.iwakura.ganyu.CommandArgumentDefinition;
import enterprises.iwakura.ganyu.CommandArgumentParser;
import enterprises.iwakura.ganyu.CommandInvocationContext;
import enterprises.iwakura.ganyu.Ganyu;
import enterprises.iwakura.ganyu.RegisteredCommand;
import enterprises.iwakura.ganyu.exception.CommandParseException;
import enterprises.iwakura.ganyu.exception.InvalidCommandArgumentsException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CommandArgumentParserImpl
implements CommandArgumentParser {
    @Override
    public CommandInvocationContext parseSimple(CommandInvocationContext ctx) throws CommandParseException {
        String[] args;
        Ganyu ganyu = ctx.getGanyu();
        RegisteredCommand command = ctx.getRegisteredCommand();
        List<CommandArgumentDefinition> argumentDefinitions = command.getArgumentDefinitions();
        CommandArgumentDefinition lastArgumentDefinition = command.getLastArgumentDefinition();
        String unprocessedArgsWithoutDoubleSpaces = ctx.getUnprocessedArguments().replaceAll("\\s+", " ").trim();
        String[] stringArray = args = unprocessedArgsWithoutDoubleSpaces.isEmpty() ? new String[]{} : unprocessedArgsWithoutDoubleSpaces.split(" ");
        if (lastArgumentDefinition == null) {
            return ctx;
        }
        int argumentIndex = 0;
        for (CommandArgumentDefinition argumentDefinition : argumentDefinitions) {
            if (argumentDefinition.isInjectable()) {
                ctx.addArgumentValue(argumentDefinition, ganyu.getInjectableArgumentResolver().resolve(argumentDefinition, ctx));
                continue;
            }
            if (lastArgumentDefinition == argumentDefinition && argumentDefinition.isGreedy() && args.length > 0) {
                StringBuilder greedyArgs = new StringBuilder();
                for (int i = argumentIndex; i < args.length; ++i) {
                    greedyArgs.append(args[i]).append(" ");
                }
                ctx.addArgumentValue(argumentDefinition, this.parseSingleArgument(ctx, argumentDefinition, greedyArgs.toString().trim()));
                argumentIndex = args.length;
                continue;
            }
            if (argumentIndex >= args.length) {
                if (argumentDefinition.isMandatory()) {
                    throw new InvalidCommandArgumentsException(ctx, argumentDefinition.getType(), argumentIndex);
                }
                ctx.addArgumentValue(argumentDefinition, this.parseSingleArgument(ctx, argumentDefinition, null));
                continue;
            }
            ctx.addArgumentValue(argumentDefinition, this.parseSingleArgument(ctx, argumentDefinition, args[argumentIndex]));
            ++argumentIndex;
        }
        return ctx;
    }

    @Override
    public CommandInvocationContext parseNamed(CommandInvocationContext ctx) throws CommandParseException {
        Ganyu ganyu = ctx.getGanyu();
        RegisteredCommand command = ctx.getRegisteredCommand();
        List<CommandArgumentDefinition> argumentDefinitions = command.getArgumentDefinitions();
        String rawArgs = ctx.getUnprocessedArguments();
        List<String> tokens = this.tokenizeArguments(rawArgs);
        int i = 0;
        while (i < tokens.size()) {
            CommandArgumentDefinition argDef;
            String token = tokens.get(i);
            ++i;
            if (!token.startsWith("-") || (argDef = CommandArgumentParserImpl.getCommandArgumentDefinition(token, argumentDefinitions)).isInjectable()) continue;
            StringBuilder valueBuilder = new StringBuilder();
            while (i < tokens.size() && !tokens.get(i).startsWith("-")) {
                if (valueBuilder.length() > 0) {
                    valueBuilder.append(" ");
                }
                valueBuilder.append(tokens.get(i));
                ++i;
            }
            String value = valueBuilder.toString();
            if (value.isEmpty() && argDef.isMandatory()) {
                if (argDef.isMandatory()) {
                    throw new CommandParseException("Missing value for argument: " + token);
                }
                value = null;
            }
            ctx.addArgumentValue(argDef, this.parseSingleArgument(ctx, argDef, value));
        }
        for (CommandArgumentDefinition argumentDefinition : argumentDefinitions) {
            if (!argumentDefinition.isInjectable()) continue;
            ctx.addArgumentValue(argumentDefinition, ganyu.getInjectableArgumentResolver().resolve(argumentDefinition, ctx));
        }
        return ctx;
    }

    protected static CommandArgumentDefinition getCommandArgumentDefinition(String token, List<CommandArgumentDefinition> argumentDefinitions) {
        boolean isLongFlag = token.startsWith("--");
        String flagName = isLongFlag ? token.substring(2) : token.substring(1);
        CommandArgumentDefinition argDef = null;
        for (CommandArgumentDefinition def : argumentDefinitions) {
            if ((!isLongFlag || !flagName.equals(def.getLongName())) && (isLongFlag || !flagName.equals(def.getName()))) continue;
            argDef = def;
            break;
        }
        if (argDef == null) {
            throw new CommandParseException("Unknown argument: " + token);
        }
        return argDef;
    }

    protected List<String> tokenizeArguments(String input) {
        if (input == null || input.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder currentToken = new StringBuilder();
        boolean inQuotes = false;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\"' && (i == 0 || input.charAt(i - 1) != '\\')) {
                inQuotes = !inQuotes;
                continue;
            }
            if (c == ' ' && !inQuotes) {
                if (currentToken.length() <= 0) continue;
                tokens.add(currentToken.toString());
                currentToken = new StringBuilder();
                continue;
            }
            currentToken.append(c);
        }
        if (currentToken.length() > 0) {
            tokens.add(currentToken.toString());
        }
        return tokens;
    }
}

