/*
 * Decompiled with CFR 0.152.
 */
package enterprises.iwakura.ganyu.impl;

import enterprises.iwakura.ganyu.CommandArgumentDefinition;
import enterprises.iwakura.ganyu.CommandInvocationContext;
import enterprises.iwakura.ganyu.CommandRegisterProcessor;
import enterprises.iwakura.ganyu.Ganyu;
import enterprises.iwakura.ganyu.GanyuCommand;
import enterprises.iwakura.ganyu.RegisteredCommand;
import enterprises.iwakura.ganyu.annotation.Command;
import enterprises.iwakura.ganyu.annotation.DefaultCommand;
import enterprises.iwakura.ganyu.annotation.Description;
import enterprises.iwakura.ganyu.annotation.ExceptionHandler;
import enterprises.iwakura.ganyu.annotation.InjectableArgument;
import enterprises.iwakura.ganyu.annotation.NamedArg;
import enterprises.iwakura.ganyu.annotation.NamedArgumentHandler;
import enterprises.iwakura.ganyu.annotation.OptionalArg;
import enterprises.iwakura.ganyu.annotation.PostCommand;
import enterprises.iwakura.ganyu.annotation.PreCommand;
import enterprises.iwakura.ganyu.annotation.SubCommand;
import enterprises.iwakura.ganyu.annotation.Syntax;
import enterprises.iwakura.ganyu.exception.CommandNotAnnotatedException;
import enterprises.iwakura.ganyu.exception.InvalidCommandMethodException;
import enterprises.iwakura.ganyu.exception.MultipleDefaultCommandMethodsException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class CommandRegisterProcessorImpl
implements CommandRegisterProcessor {
    @Override
    public List<RegisteredCommand> process(Ganyu ganyu, GanyuCommand command) {
        RegisteredCommand mainCommand = new RegisteredCommand(command);
        ArrayList<RegisteredCommand> commands = new ArrayList<RegisteredCommand>(Collections.singletonList(mainCommand));
        List<Method> defaultCommandMethods = this.listMethodsWithAnnotations(command, DefaultCommand.class);
        List<Method> standaloneCommandMethods = this.listMethodsWithAnnotations(command, Command.class);
        List<Method> subCommandMethods = this.listMethodsWithAnnotations(command, SubCommand.class);
        Optional<Method> preCommandMethod = this.listMethodsWithAnnotations(command, PreCommand.class).stream().findFirst();
        Optional<Method> postCommandMethod = this.listMethodsWithAnnotations(command, PostCommand.class).stream().findFirst();
        Optional<Method> exceptionHandlerMethod = this.listMethodsWithAnnotations(command, ExceptionHandler.class).stream().findFirst();
        this.validateParameters(command, preCommandMethod, CommandInvocationContext.class);
        this.validateParameters(command, postCommandMethod, CommandInvocationContext.class);
        this.validateParameters(command, exceptionHandlerMethod, CommandInvocationContext.class, Throwable.class);
        Optional<String> classCommandName = this.readValue(command, Command.class);
        Optional<String> classDescription = this.readValue(command, Description.class);
        Optional<String> classSyntax = this.readValue(command, Syntax.class);
        this.populateAdditionalMethods(mainCommand, preCommandMethod, postCommandMethod, exceptionHandlerMethod);
        if (defaultCommandMethods.isEmpty()) {
            mainCommand.setName(classCommandName.orElseThrow(() -> new CommandNotAnnotatedException(command, Command.class)));
            mainCommand.setDescription(classDescription.orElse(null));
            mainCommand.setSyntax(classSyntax.orElse(null));
        } else if (defaultCommandMethods.size() == 1) {
            Method defaultCommandMethod = defaultCommandMethods.get(0);
            this.parseMethod(mainCommand, defaultCommandMethod, classCommandName, classDescription, classSyntax);
        } else {
            throw new MultipleDefaultCommandMethodsException(command, defaultCommandMethods);
        }
        standaloneCommandMethods.forEach(method -> {
            RegisteredCommand standaloneCommand = new RegisteredCommand(command, (Method)method);
            this.parseMethod(standaloneCommand, (Method)method, classCommandName, classDescription, classSyntax);
            this.populateAdditionalMethods(standaloneCommand, preCommandMethod, postCommandMethod, exceptionHandlerMethod);
            commands.add(standaloneCommand);
        });
        subCommandMethods.forEach(method -> {
            RegisteredCommand subCommand = new RegisteredCommand(command, (Method)method);
            this.parseMethod(subCommand, (Method)method, Optional.empty(), Optional.empty(), Optional.empty());
            this.populateAdditionalMethods(subCommand, preCommandMethod, postCommandMethod, exceptionHandlerMethod);
            mainCommand.addSubCommand(subCommand);
        });
        for (RegisteredCommand registeredCommand : commands) {
            List<RegisteredCommand> subCommands = registeredCommand.getSubCommands();
            registeredCommand.setFullyQualifiedName(registeredCommand.getName());
            for (RegisteredCommand subCommand : subCommands) {
                subCommand.setFullyQualifiedName(String.format("%s %s", registeredCommand.getName(), subCommand.getName()));
            }
        }
        return commands;
    }

    private void populateAdditionalMethods(RegisteredCommand mainCommand, Optional<Method> preCommandMethod, Optional<Method> postCommandMethod, Optional<Method> exceptionHandlerMethod) {
        preCommandMethod.ifPresent(mainCommand::setPreCommandMethod);
        postCommandMethod.ifPresent(mainCommand::setPostCommandMethod);
        exceptionHandlerMethod.ifPresent(mainCommand::setExceptionHandlerMethod);
    }

    private void validateParameters(GanyuCommand command, Optional<Method> optionalMethod, Class<?> ... classParameters) {
        if (classParameters == null) {
            throw new NullPointerException("classParameters is marked non-null but is null");
        }
        if (!optionalMethod.isPresent()) {
            return;
        }
        Method method = optionalMethod.get();
        Parameter[] parameters = method.getParameters();
        if (parameters.length != classParameters.length) {
            throw new InvalidCommandMethodException(command, method, classParameters);
        }
        for (int i = 0; i < parameters.length; ++i) {
            if (classParameters[i].isAssignableFrom(parameters[i].getType())) continue;
            throw new InvalidCommandMethodException(command, method, classParameters);
        }
    }

    protected void parseMethod(RegisteredCommand registeredCommand, Method method, Optional<String> defaultCommandName, Optional<String> defaultDescription, Optional<String> defaultSyntax) {
        registeredCommand.setMethod(method);
        registeredCommand.setName(this.readValue(method, Command.class).orElseGet(() -> this.readValue(method, SubCommand.class).orElseGet(() -> (String)defaultCommandName.orElseThrow(() -> new CommandNotAnnotatedException(registeredCommand.getGanyuCommand(), method, Command.class)))));
        registeredCommand.setDescription(this.readValue(method, Description.class).orElseGet(() -> defaultDescription.orElse(null)));
        registeredCommand.setSyntax(this.readValue(method, Syntax.class).orElseGet(() -> defaultSyntax.orElse(null)));
        registeredCommand.setNamedArgumentHandler(method.isAnnotationPresent(NamedArgumentHandler.class));
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            CommandArgumentDefinition argumentDefinition = new CommandArgumentDefinition();
            if (registeredCommand.isNamedArgumentHandler()) {
                this.readNamedArg(parameter, argumentDefinition);
            }
            argumentDefinition.setParameterName(parameter.getName());
            argumentDefinition.setDescription(this.readValue(parameter, Description.class).orElse(null));
            argumentDefinition.setInjectable(parameter.isAnnotationPresent(InjectableArgument.class) || parameter.getType().isAnnotationPresent(InjectableArgument.class));
            argumentDefinition.setMandatory(!parameter.isAnnotationPresent(OptionalArg.class));
            argumentDefinition.setType(parameter.getType());
            argumentDefinition.setIndex(i);
            registeredCommand.addArgumentDefinition(argumentDefinition);
        }
    }

    protected Optional<Command> readCommandAnnotation(GanyuCommand command) {
        return Optional.ofNullable(command.getClass().getAnnotation(Command.class));
    }

    protected Optional<String> readValue(GanyuCommand command, Class<? extends Annotation> annotation) {
        return Optional.ofNullable(command.getClass().getAnnotation(annotation)).map(this::readAnnotationValue).filter(value -> !value.isEmpty());
    }

    protected Optional<String> readValue(Method method, Class<? extends Annotation> annotation) {
        return Optional.ofNullable(method.getAnnotation(annotation)).map(this::readAnnotationValue).filter(value -> !value.isEmpty());
    }

    protected Optional<String> readValue(Parameter parameter, Class<? extends Annotation> annotation) {
        return Optional.ofNullable(parameter.getAnnotation(annotation)).map(this::readAnnotationValue).filter(value -> !value.isEmpty());
    }

    private void readNamedArg(Parameter parameter, CommandArgumentDefinition argumentDefinition) {
        Optional.ofNullable(parameter.getAnnotation(NamedArg.class)).ifPresent(namedArg -> {
            argumentDefinition.setName(namedArg.value());
            argumentDefinition.setLongName(namedArg.longForm());
        });
    }

    protected String readAnnotationValue(Annotation annotation) {
        Method valueMethod = annotation.annotationType().getMethod("value", new Class[0]);
        Object value = valueMethod.invoke((Object)annotation, new Object[0]);
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    protected List<Method> listMethodsWithAnnotations(GanyuCommand command, Class<? extends Annotation> annotation) {
        ArrayList<Method> methodsWithAnnotations = new ArrayList<Method>();
        for (Method method : command.getClass().getDeclaredMethods()) {
            if (!method.isAnnotationPresent(annotation)) continue;
            methodsWithAnnotations.add(method);
        }
        return methodsWithAnnotations;
    }
}

