/*
 * Decompiled with CFR 0.152.
 */
package enterprises.iwakura.keqing;

import enterprises.iwakura.keqing.Serializer;
import enterprises.iwakura.keqing.util.ResourceUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;

public class Keqing {
    @Generated
    private final Object $lock = new Object[0];
    protected final List<String> effectivePostfixPriorities = new ArrayList<String>(Collections.singletonList(""));
    protected final List<String> postfixPriorities = new ArrayList<String>();
    protected char postfixSeparator = (char)95;
    protected Serializer<?> serializer;
    protected String defaultPostfix;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPostfixPriorities(List<String> postfixPriorities) {
        Object object = this.$lock;
        synchronized (object) {
            this.postfixPriorities.clear();
            this.postfixPriorities.addAll(postfixPriorities);
            this.updateEffectivePostfixes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultPostfix(String postfix) {
        Object object = this.$lock;
        synchronized (object) {
            this.defaultPostfix = postfix;
            this.updateEffectivePostfixes();
        }
    }

    protected void updateEffectivePostfixes() {
        this.effectivePostfixPriorities.clear();
        if (this.defaultPostfix != null && !this.defaultPostfix.isEmpty()) {
            this.effectivePostfixPriorities.add(this.defaultPostfix);
        }
        this.effectivePostfixPriorities.addAll(this.postfixPriorities);
        this.effectivePostfixPriorities.add("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readProperty(String postfix, String path, Class<T> clazz) {
        Object object = this.$lock;
        synchronized (object) {
            if (this.serializer == null) {
                throw new IllegalStateException("Serializer is not loaded");
            }
            boolean effectivePostfixExists = this.effectivePostfixPriorities.stream().anyMatch(p -> p.equals(postfix));
            String string = effectivePostfixExists ? null : postfix;
            return this.serializer.readProperty(string, this.effectivePostfixPriorities, path, clazz).orElse(null);
        }
    }

    public <T> List<T> readPropertyList(String postfix, String path, Class<T> clazz) {
        T property = this.readProperty(postfix, path, clazz);
        if (property instanceof List) {
            return (List)property;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readProperty(String path, Class<T> clazz) {
        Object object = this.$lock;
        synchronized (object) {
            if (this.defaultPostfix == null) {
                throw new IllegalStateException("Default postfix is not set.");
            }
            return this.readProperty(this.defaultPostfix, path, clazz);
        }
    }

    public <T> List<T> readPropertyList(String path, Class<T> clazz) {
        if (this.defaultPostfix == null) {
            throw new IllegalStateException("Default postfix is not set.");
        }
        return this.readPropertyList(this.defaultPostfix, path, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromFileSystem(String filePathTemplate, char postfixSeparator, Serializer<?> serializer) throws IOException {
        Object object = this.$lock;
        synchronized (object) {
            this.postfixSeparator = postfixSeparator;
            this.serializer = serializer;
            File fileTemplate = new File(filePathTemplate);
            Path directory = fileTemplate.getParentFile().toPath();
            String filePrefix = fileTemplate.getName();
            try (Stream<Path> files = Files.list(directory).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));){
                files.forEach(file -> {
                    String fileExtension;
                    String fileName = file.getFileName().toString();
                    String string = fileExtension = fileName.contains(".") ? fileName.substring(fileName.lastIndexOf(46) + 1) : "";
                    if (fileName.startsWith(filePrefix) && serializer.supportsFileExtension(fileExtension)) {
                        String postfix = "";
                        int separatorIndex = fileName.indexOf(postfixSeparator, filePrefix.length());
                        if (separatorIndex != -1) {
                            postfix = fileName.substring(separatorIndex + 1, fileName.length() - fileExtension.length() - 1);
                        }
                        try {
                            String content = new String(Files.readAllBytes(file), StandardCharsets.UTF_8);
                            serializer.serialize(postfix, content);
                        }
                        catch (IOException exception) {
                            throw new RuntimeException("Failed to read file: " + file, exception);
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromResources(String filePathTemplate, char postfixSeparator, Serializer<?> serializer, ClassLoader classLoader) throws IOException {
        Object object = this.$lock;
        synchronized (object) {
            String directorySymbolUsed;
            this.postfixSeparator = postfixSeparator;
            this.serializer = serializer;
            String string = directorySymbolUsed = filePathTemplate.contains("/") ? "/" : "\\";
            if (filePathTemplate.startsWith(directorySymbolUsed)) {
                filePathTemplate = filePathTemplate.substring(1);
            }
            String resourceDirectory = filePathTemplate.contains(directorySymbolUsed) ? filePathTemplate.substring(0, filePathTemplate.lastIndexOf(directorySymbolUsed)) : "";
            String filePrefix = filePathTemplate.contains(directorySymbolUsed) ? filePathTemplate.substring(filePathTemplate.lastIndexOf(directorySymbolUsed) + 1) : filePathTemplate;
            ResourceUtils.listResourceFiles(resourceDirectory, classLoader).forEach(resourceFile -> {
                String fileExtension;
                String string = fileExtension = resourceFile.contains(".") ? resourceFile.substring(resourceFile.lastIndexOf(46) + 1) : "";
                if (resourceFile.startsWith(filePrefix) && serializer.supportsFileExtension(fileExtension)) {
                    String postfix = "";
                    int separatorIndex = resourceFile.indexOf(postfixSeparator, filePrefix.length());
                    if (separatorIndex != -1) {
                        postfix = resourceFile.substring(separatorIndex + 1, resourceFile.length() - fileExtension.length() - 1);
                    }
                    try {
                        String content;
                        String resourcePath = (resourceDirectory.isEmpty() ? "" : resourceDirectory + "/") + resourceFile;
                        InputStream resourceStream = classLoader.getResourceAsStream(resourcePath);
                        if (resourceStream == null) {
                            throw new RuntimeException("Resource not found: " + resourcePath);
                        }
                        try (ByteArrayOutputStream result = new ByteArrayOutputStream();){
                            int length;
                            byte[] buffer = new byte[1024];
                            while ((length = resourceStream.read(buffer)) != -1) {
                                result.write(buffer, 0, length);
                            }
                            content = result.toString(StandardCharsets.UTF_8.name());
                        }
                        serializer.serialize(postfix, content);
                    }
                    catch (IOException exception) {
                        throw new RuntimeException("Failed to read resource: " + resourceFile, exception);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromResources(String filePathTemplate, char postfixSeparator, Serializer<?> serializer) throws IOException {
        Object object = this.$lock;
        synchronized (object) {
            this.loadFromResources(filePathTemplate, postfixSeparator, serializer, Thread.currentThread().getContextClassLoader());
        }
    }

    @Generated
    public List<String> getEffectivePostfixPriorities() {
        return this.effectivePostfixPriorities;
    }

    @Generated
    public List<String> getPostfixPriorities() {
        return this.postfixPriorities;
    }

    @Generated
    public char getPostfixSeparator() {
        return this.postfixSeparator;
    }

    @Generated
    public Serializer<?> getSerializer() {
        return this.serializer;
    }

    @Generated
    public String getDefaultPostfix() {
        return this.defaultPostfix;
    }

    @Generated
    public void setPostfixSeparator(char postfixSeparator) {
        this.postfixSeparator = postfixSeparator;
    }

    @Generated
    public void setSerializer(Serializer<?> serializer) {
        this.serializer = serializer;
    }
}

