/*
 * Decompiled with CFR 0.152.
 */
package enterprises.iwakura.keqing.impl;

import enterprises.iwakura.keqing.Serializer;
import java.io.IOException;
import java.io.StringReader;
import java.util.Optional;
import java.util.Properties;

public class PropertiesSerializer
extends Serializer<Properties> {
    public static final String FILE_EXTENSION = "properties";

    @Override
    public boolean supportsFileExtension(String extension) {
        return FILE_EXTENSION.equalsIgnoreCase(extension);
    }

    @Override
    public void serialize(String postfix, String content) throws IOException {
        Properties properties = new Properties();
        properties.load(new StringReader(content));
        this.serializedFileContents.put(postfix, properties);
    }

    @Override
    public <T> Optional<T> readProperty(String postfix, String path, Class<T> clazz) {
        T property;
        Properties properties = (Properties)this.serializedFileContents.get(postfix);
        if (properties != null && (property = this.parseValue(properties.getProperty(path), clazz)) != null) {
            return Optional.of(property);
        }
        return Optional.empty();
    }

    private <T> T parseValue(String property, Class<T> clazz) {
        if (property == null) {
            return null;
        }
        if (clazz == String.class) {
            return clazz.cast(property);
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return clazz.cast(Integer.parseInt(property));
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return clazz.cast(Long.parseLong(property));
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return clazz.cast(Double.parseDouble(property));
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return clazz.cast(Float.valueOf(Float.parseFloat(property)));
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return clazz.cast(Boolean.parseBoolean(property));
        }
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            return clazz.cast(Byte.parseByte(property));
        }
        if (clazz == Short.class || clazz == Short.TYPE) {
            return clazz.cast(Short.parseShort(property));
        }
        if (clazz == Character.class || clazz == Character.TYPE) {
            return clazz.cast(Character.valueOf(property.charAt(0)));
        }
        throw new IllegalArgumentException("Unsupported class type: " + clazz.getName());
    }
}

