/*
 * Decompiled with CFR 0.152.
 */
package enterprises.iwakura.keqing.util;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import lombok.Generated;

public final class ResourceUtils {
    public static List<String> listResourceFiles(String directory, ClassLoader classLoader) throws IOException {
        ArrayList<String> filenames = new ArrayList<String>();
        Enumeration<URL> resources = classLoader.getResources(directory);
        while (resources.hasMoreElements()) {
            URL resourceUrl = resources.nextElement();
            if (resourceUrl.getProtocol().equals("file")) {
                try {
                    Path directoryPath = Paths.get(resourceUrl.toURI());
                    Stream<Path> files = Files.walk(directoryPath, 1, new FileVisitOption[0]);
                    try {
                        files.filter(path -> !path.equals(directoryPath)).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(path -> path.getFileName().toString()).forEach(filenames::add);
                        continue;
                    }
                    finally {
                        if (files == null) continue;
                        files.close();
                        continue;
                    }
                }
                catch (URISyntaxException e) {
                    throw new IOException("Failed to convert URL to URI", e);
                }
            }
            if (!resourceUrl.getProtocol().equals("jar")) continue;
            String jarPath = resourceUrl.getPath();
            String jarFilePath = jarPath.substring(5, jarPath.indexOf("!"));
            String directoryInJar = directory.replace('.', '/');
            try (JarFile jarFile = new JarFile(URLDecoder.decode(jarFilePath, StandardCharsets.UTF_8.name()));){
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    String relativeName;
                    JarEntry entry = entries.nextElement();
                    String entryName = entry.getName();
                    if (entry.isDirectory() || !entryName.startsWith(directoryInJar + "/") || (relativeName = entryName.substring(directoryInJar.length() + 1)).contains("/")) continue;
                    filenames.add(relativeName);
                }
            }
        }
        return filenames;
    }

    @Generated
    private ResourceUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

