/*
 * Decompiled with CFR 0.152.
 */
package enterprises.iwakura.keqing.impl;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import enterprises.iwakura.keqing.Serializer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public class GsonSerializer
extends Serializer<JsonElement> {
    public static final String FILE_EXTENSION = "json";
    protected final Gson gson;

    public GsonSerializer() {
        this.gson = new Gson();
    }

    public boolean supportsFileExtension(String extension) {
        return FILE_EXTENSION.equalsIgnoreCase(extension);
    }

    public void serialize(String postfix, String content) throws IOException {
        try {
            this.serializedFileContents.put(postfix, JsonParser.parseString((String)content));
        }
        catch (Exception exception) {
            throw new IOException(String.format("Failed to parse JSON content for postfix %s: %s", postfix, content), exception);
        }
    }

    public <T> Optional<T> readProperty(String postfix, List<String> postfixPriorities, String path, Class<T> clazz) {
        int currentIndex;
        ArrayList<JsonElement> jsonElements = new ArrayList<JsonElement>();
        String currentPostfix = postfix == null ? (!postfixPriorities.isEmpty() ? postfixPriorities.get(0) : null) : postfix;
        int n = currentIndex = postfix != null ? -1 : 0;
        while (currentPostfix != null) {
            JsonElement elementByPath;
            JsonElement jsonElement = (JsonElement)this.serializedFileContents.get(currentPostfix);
            if (jsonElement != null && (elementByPath = this.getElementByPath(jsonElement, path)) != null) {
                jsonElements.add(elementByPath);
            }
            currentPostfix = ++currentIndex < postfixPriorities.size() ? postfixPriorities.get(currentIndex) : null;
        }
        if (jsonElements.isEmpty()) {
            return Optional.empty();
        }
        JsonElement firstNonNullElement = (JsonElement)jsonElements.get(0);
        if (firstNonNullElement == null || firstNonNullElement.isJsonNull() || firstNonNullElement.isJsonPrimitive()) {
            return Optional.ofNullable(this.parseElement(firstNonNullElement, clazz));
        }
        if (firstNonNullElement.isJsonObject()) {
            JsonObject mergedJsonObject = this.mergeObjects(jsonElements);
            return Optional.ofNullable(this.parseElement((JsonElement)mergedJsonObject, clazz));
        }
        if (firstNonNullElement.isJsonArray()) {
            JsonArray mergedJsonArray = this.mergeArrays(jsonElements);
            return Optional.ofNullable(this.parseElement((JsonElement)mergedJsonArray, clazz));
        }
        return Optional.empty();
    }

    protected JsonObject mergeObjects(List<JsonElement> jsonElements) {
        JsonObject jsonObject = new JsonObject();
        Collections.reverse(jsonElements);
        jsonElements.forEach(jsonElement -> {
            if (jsonElement.isJsonObject()) {
                this.deepMerge(jsonElement.getAsJsonObject(), jsonObject);
            }
        });
        return jsonObject;
    }

    protected JsonArray mergeArrays(List<JsonElement> jsonElements) {
        JsonArray jsonArray = new JsonArray();
        Collections.reverse(jsonElements);
        jsonElements.forEach(jsonElement -> {
            if (jsonElement.isJsonArray()) {
                jsonElement.getAsJsonArray().forEach(arg_0 -> ((JsonArray)jsonArray).add(arg_0));
            }
        });
        return jsonArray;
    }

    protected void deepMerge(JsonObject source, JsonObject target) {
        for (String key : source.keySet()) {
            JsonElement sourceValue = source.get(key);
            if (target.has(key)) {
                JsonElement targetValue = target.get(key);
                if (sourceValue.isJsonObject() && targetValue.isJsonObject()) {
                    this.deepMerge(sourceValue.getAsJsonObject(), targetValue.getAsJsonObject());
                    continue;
                }
                if (sourceValue.isJsonArray() && targetValue.isJsonArray()) {
                    JsonArray mergedArray = new JsonArray();
                    targetValue.getAsJsonArray().forEach(arg_0 -> ((JsonArray)mergedArray).add(arg_0));
                    sourceValue.getAsJsonArray().forEach(arg_0 -> ((JsonArray)mergedArray).add(arg_0));
                    target.add(key, (JsonElement)mergedArray);
                    continue;
                }
                target.add(key, sourceValue);
                continue;
            }
            target.add(key, sourceValue);
        }
    }

    protected <T> T parseElement(JsonElement element, Class<T> clazz) {
        if (element == null || element.isJsonNull()) {
            return null;
        }
        if (element.isJsonPrimitive()) {
            return (T)this.gson.fromJson(element, this.getWrapperClass(clazz));
        }
        if (element.isJsonObject()) {
            return (T)this.gson.fromJson(element, clazz);
        }
        if (element.isJsonArray()) {
            return (T)this.gson.fromJson(element, TypeToken.getParameterized(List.class, (Type[])new Type[]{clazz}).getType());
        }
        return null;
    }

    protected Class<?> getWrapperClass(Class<?> clazz) {
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        return clazz;
    }

    protected JsonElement getElementByPath(JsonElement jsonElement, String path) {
        if (path.isEmpty()) {
            return jsonElement;
        }
        String[] keys = path.split("\\.");
        JsonElement currentElement = jsonElement;
        for (int currentIndex = 0; currentElement != null && currentElement.isJsonObject() && currentIndex < keys.length; ++currentIndex) {
            JsonObject jsonObject = currentElement.getAsJsonObject();
            currentElement = jsonObject.get(keys[currentIndex]);
        }
        return currentElement;
    }

    public <T> Optional<T> readProperty(String postfix, String path, Class<T> clazz) {
        throw new UnsupportedOperationException("Use readProperty with postfixPriorities for correct JSON merging behavior.");
    }

    @Generated
    public Gson getGson() {
        return this.gson;
    }

    @Generated
    public GsonSerializer(Gson gson) {
        this.gson = gson;
    }
}

