/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.base;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ResourceUtil {
    protected static String[] getResourceListing(String path) throws URISyntaxException, IOException {
        URL dirURL = Thread.currentThread().getContextClassLoader().getResource(path);
        if (dirURL != null) {
            if (dirURL.getProtocol().equals("file")) {
                return new File(dirURL.toURI()).list();
            }
            if (dirURL.getProtocol().equals("jar")) {
                String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
                JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
                Enumeration<JarEntry> entries = jar.entries();
                HashSet<String> result = new HashSet<String>();
                while (entries.hasMoreElements()) {
                    String name = entries.nextElement().getName();
                    if (!name.startsWith(path)) continue;
                    String entry = name.substring(path.length());
                    int checkSubdir = entry.indexOf("/");
                    if (checkSubdir >= 0) {
                        entry = entry.substring(0, checkSubdir);
                    }
                    if (entry.length() <= 0) continue;
                    result.add(entry);
                }
                jar.close();
                return result.toArray(new String[result.size()]);
            }
        }
        return null;
    }

    public static void forAllEntries(String root, String fileSuffix, OnEntry toDo) throws IOException, URISyntaxException {
        String[] paths;
        LinkedList<String> path = new LinkedList<String>();
        if (!root.endsWith("/")) {
            root = root + "/";
        }
        if ((paths = ResourceUtil.getResourceListing(root)) != null) {
            for (String i : paths) {
                path.add(root + i);
            }
        }
        while (!path.isEmpty()) {
            String next = (String)path.remove();
            if (!next.endsWith(fileSuffix)) {
                String nextRoot = next.endsWith("/") ? next : next + "/";
                paths = ResourceUtil.getResourceListing(nextRoot);
                if (paths == null) continue;
                for (String i : paths) {
                    path.add(nextRoot + i);
                }
                continue;
            }
            InputStream nextData = Thread.currentThread().getContextClassLoader().getResourceAsStream(next);
            if (nextData == null) continue;
            toDo.nextEntry(next, nextData);
            nextData.close();
        }
    }

    public static interface OnEntry {
        public void nextEntry(String var1, InputStream var2);
    }
}

