/*
 * Decompiled with CFR 0.152.
 */
package com.ervacon.springframework.web.servlet.mvc.webflow;

import com.ervacon.springframework.web.servlet.mvc.webflow.Action;
import com.ervacon.springframework.web.servlet.mvc.webflow.WebFlowException;
import java.util.Map;
import javax.naming.OperationNotSupportedException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.BaseCommandController;

public class BindAndValidateCommandAction
extends BaseCommandController
implements Action {
    private boolean reuseCommand = false;

    public boolean isReuseCommand() {
        return this.reuseCommand;
    }

    public void setReuseCommand(boolean reuseCommand) {
        this.reuseCommand = reuseCommand;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        throw new OperationNotSupportedException("BindAndValidateCommandAction does not support handleRequestInternal()");
    }

    public String execute(HttpServletRequest request, HttpServletResponse response, Map model) {
        try {
            Object command = this.getCommand(request, model);
            ServletRequestDataBinder binder = this.bindAndValidate(request, command);
            model.put(this.getCommandName(), command);
            model.putAll(binder.getErrors().getModel());
            return binder.getErrors().hasErrors() ? "error" : "ok";
        }
        catch (Exception e) {
            throw new WebFlowException("cannot get, bind or validate command object: " + e.getMessage(), e);
        }
    }

    protected Object getCommand(HttpServletRequest request, Map model) throws Exception {
        if (this.isReuseCommand() && model.containsKey(this.getCommandName())) {
            return model.get(this.getCommandName());
        }
        return this.createCommand();
    }
}

