/*
 * Decompiled with CFR 0.152.
 */
package com.ervacon.springframework.web.servlet.mvc.webflow;

import com.ervacon.springframework.web.servlet.mvc.webflow.Action;
import com.ervacon.springframework.web.servlet.mvc.webflow.ModelMapper;
import com.ervacon.springframework.web.servlet.mvc.webflow.NavigationException;
import com.ervacon.springframework.web.servlet.mvc.webflow.WebFlow;
import com.ervacon.springframework.web.servlet.mvc.webflow.WebFlowDtdResolver;
import com.ervacon.springframework.web.servlet.mvc.webflow.WebFlowException;
import com.ervacon.springframework.web.servlet.mvc.webflow.WebFlowMemento;
import com.ervacon.springframework.web.servlet.mvc.webflow.WebFlowMementoStack;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.springframework.web.servlet.ModelAndView;
import org.xml.sax.EntityResolver;

public class SimpleWebFlow
implements WebFlow,
InitializingBean,
ApplicationContextAware {
    protected final Log log = LogFactory.getLog((Class)(class$com$ervacon$springframework$web$servlet$mvc$webflow$SimpleWebFlow == null ? (class$com$ervacon$springframework$web$servlet$mvc$webflow$SimpleWebFlow = SimpleWebFlow.class$("com.ervacon.springframework.web.servlet.mvc.webflow.SimpleWebFlow")) : class$com$ervacon$springframework$web$servlet$mvc$webflow$SimpleWebFlow));
    private Resource webFlowResource = null;
    private Document webFlowDef = null;
    private ApplicationContext appCtx = null;
    static /* synthetic */ Class class$com$ervacon$springframework$web$servlet$mvc$webflow$SimpleWebFlow;

    public Resource getWebFlowResource() {
        return this.webFlowResource;
    }

    public void setWebFlowResource(Resource webFlowResource) {
        this.webFlowResource = webFlowResource;
    }

    public void afterPropertiesSet() throws Exception {
        this.load();
    }

    public void load() throws WebFlowException {
        try {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Loading web flow from " + this.webFlowResource));
            }
            SAXBuilder builder = new SAXBuilder();
            builder.setValidation(true);
            builder.setEntityResolver((EntityResolver)new WebFlowDtdResolver());
            this.webFlowDef = builder.build(this.webFlowResource.getInputStream());
        }
        catch (IOException e) {
            throw new WebFlowException("cannot load web flow: " + e.getMessage(), e);
        }
        catch (JDOMException e) {
            throw new WebFlowException("problem parsing web flow definition: " + e.getMessage(), e);
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.appCtx;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.appCtx = applicationContext;
    }

    public String getName() {
        return this.webFlowDef.getRootElement().getAttributeValue("name");
    }

    public ModelAndView start(HttpServletRequest request, HttpServletResponse response, WebFlowMementoStack mementos) throws WebFlowException {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Starting web flow '" + this.getName() + "'"));
        }
        Element startState = this.webFlowDef.getRootElement().getChild("start-state");
        return this.executeState(request, response, startState.getAttributeValue("state"), mementos);
    }

    public ModelAndView execute(HttpServletRequest request, HttpServletResponse response, String state, String event, WebFlowMementoStack mementos) throws WebFlowException {
        Element stateDef;
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Executing event '" + event + "' in state '" + state + "' of web flow '" + this.getName() + "'"));
        }
        if ((stateDef = this.findStateDef(state)) == null) {
            throw new NavigationException("cannot find state '" + state + "' in web flow '" + this.getName() + "'", state, event, mementos);
        }
        Element triggeredTransitionDef = this.findTransitionDef(stateDef, event);
        if (triggeredTransitionDef == null) {
            throw new NavigationException("cannot find transition for event '" + event + "' in state '" + state + "' of flow '" + this.getName() + "'", state, event, mementos);
        }
        return this.executeState(request, response, triggeredTransitionDef.getAttributeValue("to"), mementos);
    }

    protected Element findStateDef(String state) {
        List stateDefs = this.webFlowDef.getRootElement().getChildren();
        for (int i = 0; i < stateDefs.size(); ++i) {
            Element stateDef = (Element)stateDefs.get(i);
            if (!state.equals(stateDef.getAttributeValue("id"))) continue;
            return stateDef;
        }
        return null;
    }

    protected Element findTransitionDef(Element stateDef, String event) {
        List transitionDefs = stateDef.getChildren("transition");
        for (int i = 0; i < transitionDefs.size(); ++i) {
            Element transitionDef = (Element)transitionDefs.get(i);
            if (!event.equals(transitionDef.getAttributeValue("name"))) continue;
            return transitionDef;
        }
        return null;
    }

    protected ModelAndView executeState(HttpServletRequest request, HttpServletResponse response, String state, WebFlowMementoStack mementos) throws WebFlowException {
        Element stateDef = this.findStateDef(state);
        if (stateDef == null) {
            throw new NavigationException("cannot find state '" + state + "' in web flow '" + this.getName() + "'", state, null, mementos);
        }
        return this.executeState(request, response, stateDef, mementos);
    }

    protected ModelAndView executeState(HttpServletRequest request, HttpServletResponse response, Element stateDef, WebFlowMementoStack mementos) throws WebFlowException {
        String state = stateDef.getAttributeValue("id");
        mementos.setCurrentState(state);
        if ("view-state".equals(stateDef.getName())) {
            return this.executeViewState(request, response, stateDef, mementos);
        }
        if ("action-state".equals(stateDef.getName())) {
            return this.executeActionState(request, response, stateDef, mementos);
        }
        if ("flow-state".equals(stateDef.getName())) {
            return this.executeFlowState(request, response, stateDef, mementos);
        }
        if ("end-state".equals(stateDef.getName())) {
            return this.executeEndState(request, response, stateDef, mementos);
        }
        throw new WebFlowException("unknown state type: " + stateDef.getName());
    }

    protected ModelAndView executeViewState(HttpServletRequest request, HttpServletResponse response, Element stateDef, WebFlowMementoStack mementos) throws WebFlowException {
        String viewStateView = stateDef.getAttributeValue("view");
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Executing view state '" + stateDef.getAttributeValue("id") + "' of flow '" + this.getName() + "': displaying view '" + viewStateView + "'"));
        }
        if (viewStateView != null) {
            ModelAndView mav = new ModelAndView(viewStateView);
            mav.addAllObjects(mementos.getModel());
            return mav;
        }
        return null;
    }

    protected ModelAndView executeActionState(HttpServletRequest request, HttpServletResponse response, Element stateDef, WebFlowMementoStack mementos) throws WebFlowException {
        Element triggeredTransitionDef = null;
        String state = stateDef.getAttributeValue("id");
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Executing action state '" + state + "' of flow '" + this.getName() + "'"));
        }
        List actionDefs = stateDef.getChildren("action");
        for (int i = 0; i < actionDefs.size(); ++i) {
            Element actionDef = (Element)actionDefs.get(i);
            String actionName = actionDef.getAttributeValue("name");
            Action action = (Action)this.appCtx.getBean(actionDef.getAttributeValue("bean"));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Executing action '" + action + "'"));
            }
            String event = action.execute(request, response, mementos.peek().getModel());
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Action '" + action + "' signaled event '" + event + "'"));
            }
            if (event == null) {
                throw new WebFlowException("action '" + action + "' signaled an invalid null event");
            }
            String realEvent = actionName + '.' + event;
            triggeredTransitionDef = this.findTransitionDef(stateDef, realEvent);
            if (triggeredTransitionDef == null) continue;
            if (!this.log.isInfoEnabled()) break;
            this.log.info((Object)("Action '" + action + "' triggered transition '" + triggeredTransitionDef.getAttributeValue("name") + "', switching to state '" + triggeredTransitionDef.getAttributeValue("to") + "'"));
            break;
        }
        if (triggeredTransitionDef == null) {
            throw new WebFlowException("no transition was triggered during execution of action state " + state);
        }
        return this.executeState(request, response, triggeredTransitionDef.getAttributeValue("to"), mementos);
    }

    protected ModelAndView executeFlowState(HttpServletRequest request, HttpServletResponse response, Element stateDef, WebFlowMementoStack mementos) throws WebFlowException {
        String subFlowName = stateDef.getAttributeValue("flow");
        SimpleWebFlow subFlow = (SimpleWebFlow)this.appCtx.getBean(subFlowName);
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Executing flow state '" + stateDef.getAttributeValue("id") + "' of flow '" + this.getName() + "': starting sub flow '" + subFlow.getName() + "'"));
        }
        WebFlowMemento subFlowMemento = new WebFlowMemento(subFlowName);
        if (stateDef.getAttributeValue("model-mapper") != null) {
            ModelMapper mapper = (ModelMapper)this.appCtx.getBean(stateDef.getAttributeValue("model-mapper"));
            mapper.mapToSubFlow(mementos.getModel(), subFlowMemento.getModel());
        }
        mementos.push(subFlowMemento);
        return subFlow.start(request, response, mementos);
    }

    protected ModelAndView executeEndState(HttpServletRequest request, HttpServletResponse response, Element stateDef, WebFlowMementoStack mementos) throws WebFlowException {
        String endStateView;
        ModelAndView mav = null;
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Executing end state '" + stateDef.getAttributeValue("id") + "' of flow '" + this.getName() + "'"));
        }
        if ((endStateView = stateDef.getAttributeValue("view")) != null) {
            mav = new ModelAndView(endStateView);
            mav.addAllObjects(mementos.getModel());
        }
        WebFlowMemento poppedMemento = mementos.pop();
        if (!mementos.empty()) {
            Element parentStateDef;
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Continuing parent flow '" + mementos.getFlowName() + "' in state '" + mementos.getCurrentState() + "' using event '" + poppedMemento.getCurrentState() + "'"));
            }
            if ((parentStateDef = ((SimpleWebFlow)mementos.getFlow(this.getApplicationContext())).findStateDef(mementos.getCurrentState())).getAttributeValue("model-mapper") != null) {
                ModelMapper mapper = (ModelMapper)this.appCtx.getBean(parentStateDef.getAttributeValue("model-mapper"));
                mapper.mapFromSubFlow(mementos.getModel(), poppedMemento.getModel());
            }
            mav = mementos.getFlow(this.getApplicationContext()).execute(request, response, mementos.getCurrentState(), poppedMemento.getCurrentState(), mementos);
        }
        return mav;
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("WebFlow '").append(this.getName()).append("' (").append(this.getWebFlowResource()).append(")");
        return res.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

