/*
 * Decompiled with CFR 0.152.
 */
package com.ervacon.springframework.web.servlet.mvc.webflow;

import com.ervacon.springframework.web.servlet.mvc.webflow.NavigationException;
import com.ervacon.springframework.web.servlet.mvc.webflow.WebFlowController;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

public class SubFlowBackNavigationExceptionResolver
implements HandlerExceptionResolver,
ApplicationContextAware {
    protected final Log log = LogFactory.getLog((Class)(class$com$ervacon$springframework$web$servlet$mvc$webflow$SubFlowBackNavigationExceptionResolver == null ? (class$com$ervacon$springframework$web$servlet$mvc$webflow$SubFlowBackNavigationExceptionResolver = SubFlowBackNavigationExceptionResolver.class$("com.ervacon.springframework.web.servlet.mvc.webflow.SubFlowBackNavigationExceptionResolver")) : class$com$ervacon$springframework$web$servlet$mvc$webflow$SubFlowBackNavigationExceptionResolver));
    private ApplicationContext appCtx;
    static /* synthetic */ Class class$com$ervacon$springframework$web$servlet$mvc$webflow$SubFlowBackNavigationExceptionResolver;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.appCtx = applicationContext;
    }

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        if (handler instanceof WebFlowController && ex instanceof NavigationException) {
            NavigationException nex = (NavigationException)((Object)ex);
            if (nex.getState() != null && nex.getEvent() != null && nex.getMementos() != null) {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("Trying to resolve navigation exception '" + (Object)((Object)nex) + "'"));
                }
                while (!nex.getMementos().empty()) {
                    try {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Trying to execute event '" + nex.getEvent() + "' in state '" + nex.getState() + "' of flow '" + nex.getMementos().getFlowName() + "'"));
                        }
                        return nex.getMementos().getFlow(this.appCtx).execute(request, response, nex.getState(), nex.getEvent(), nex.getMementos());
                    }
                    catch (NavigationException e) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Navigation failed: '" + (Object)((Object)e) + "'"));
                            this.log.debug((Object)("Popping sub flow '" + nex.getMementos().getFlowName() + "' and trying parent flow"));
                        }
                        nex.getMementos().pop();
                    }
                }
            }
            throw nex;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

