/*
 * Decompiled with CFR 0.152.
 */
package com.ervacon.springframework.web.servlet.mvc.webflow;

import com.ervacon.springframework.web.servlet.mvc.webflow.WebFlowMementoStack;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.web.filter.OncePerRequestFilter;

public class WebFlowCleanupFilter
extends OncePerRequestFilter {
    public static final int DEFAULT_TIMEOUT = 10;
    private int timeout = 10;

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        this.doCleanup(request);
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected void doCleanup(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return;
        }
        HashSet<String> namesToBeDeleted = new HashSet<String>();
        Enumeration names = session.getAttributeNames();
        while (names.hasMoreElements()) {
            WebFlowMementoStack mementos;
            String name = (String)names.nextElement();
            Object value = session.getAttribute(name);
            if (!(value instanceof WebFlowMementoStack) || !this.hasExpired(request, mementos = (WebFlowMementoStack)value)) continue;
            namesToBeDeleted.add(name);
            if (!this.logger.isInfoEnabled()) continue;
            this.logger.info((Object)("Flow '" + mementos.getFlowName() + "' with id '" + name + "' has expired and will be removed from the HTTP session '" + session.getId() + "'"));
        }
        Iterator it = namesToBeDeleted.iterator();
        while (it.hasNext()) {
            session.removeAttribute((String)it.next());
        }
    }

    protected boolean hasExpired(HttpServletRequest request, WebFlowMementoStack mementos) {
        return System.currentTimeMillis() - mementos.getLastAccessedTime() > (long)(this.getTimeout() * 60000);
    }
}

