/*
 * Decompiled with CFR 0.152.
 */
package com.ervacon.springframework.web.servlet.mvc.webflow;

import com.ervacon.springframework.web.servlet.mvc.webflow.NavigationException;
import com.ervacon.springframework.web.servlet.mvc.webflow.ParameterExtractor;
import com.ervacon.springframework.web.servlet.mvc.webflow.RequestParameterValueParameterExtractor;
import com.ervacon.springframework.web.servlet.mvc.webflow.WebFlow;
import com.ervacon.springframework.web.servlet.mvc.webflow.WebFlowMemento;
import com.ervacon.springframework.web.servlet.mvc.webflow.WebFlowMementoStack;
import com.ervacon.springframework.web.servlet.mvc.webflow.WebFlowUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class WebFlowController
extends AbstractController
implements InitializingBean {
    public static final String PARAM_FLOW_ID = "_flowId";
    public static final String PARAM_FLOW_NAME = "_flowName";
    public static final String PARAM_CURRENT_STATE = "_currentState";
    public static final String PARAM_EVENT = "_event";
    public static final String FLOW_ID_MODEL_NAME = "flowId";
    public static final String CURRENT_STATE_MODEL_NAME = "currentState";
    private String webFlowName = null;
    private ParameterExtractor parameterExtractor = new RequestParameterValueParameterExtractor();
    private String flowIdModelName = "flowId";
    private String currentStateModelName = "currentState";

    public String getWebFlowName() {
        return this.webFlowName;
    }

    public void setWebFlowName(String webFlowName) {
        this.webFlowName = webFlowName;
    }

    public ParameterExtractor getParameterExtractor() {
        return this.parameterExtractor;
    }

    public void setParameterExtractor(ParameterExtractor parameterExtractor) {
        this.parameterExtractor = parameterExtractor;
    }

    public String getFlowIdModelName() {
        return this.flowIdModelName;
    }

    public void setFlowIdModelName(String flowIdModelName) {
        this.flowIdModelName = flowIdModelName;
    }

    public String getCurrentStateModelName() {
        return this.currentStateModelName;
    }

    public void setCurrentStateModelName(String currentStateModelName) {
        this.currentStateModelName = currentStateModelName;
    }

    public void afterPropertiesSet() throws Exception {
        this.setRequireSession(true);
        if (!(this.getWebFlowName() == null || this.getApplicationContext().containsBean(this.getWebFlowName()) && this.getApplicationContext().getBean(this.getWebFlowName()) instanceof WebFlow)) {
            throw new IllegalArgumentException("webFlowName cannot be '" + this.getWebFlowName() + "', this is not the id of a web flow bean in the application context");
        }
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView mav = null;
        String flowId = this.getParameter(request, PARAM_FLOW_ID);
        String currentState = null;
        String event = null;
        WebFlowMementoStack mementos = null;
        try {
            if (flowId == null) {
                flowId = this.generateId();
                String flowName = this.getParameter(request, PARAM_FLOW_NAME);
                if (flowName == null) {
                    flowName = this.getWebFlowName();
                }
                if (flowName == null) {
                    throw new IllegalArgumentException("unable to determine the name of the flow to start -- either set the 'webFlowName' property of the controller or specify a '_flowName' request parameter");
                }
                mementos = this.createMementos(flowName, flowId);
                this.saveMementos(request, flowId, mementos);
                mav = this.getWebFlow(flowName).start(request, response, mementos);
            } else {
                mementos = this.loadMementos(request, flowId);
                if (mementos == null) {
                    throw new IllegalArgumentException("unable to recover web flow memento for flow '" + flowId + "'");
                }
                currentState = this.getParameter(request, PARAM_CURRENT_STATE);
                if (currentState == null) {
                    currentState = mementos.getCurrentState();
                }
                if ((event = this.getParameter(request, PARAM_EVENT)) == null) {
                    throw new IllegalArgumentException("make sure you provide a valid '_event' parameter when submiting a request to an existing flow");
                }
                mav = this.getWebFlow(mementos.getFlowName()).execute(request, response, currentState, event, mementos);
            }
        }
        catch (NavigationException e) {
            if (currentState != null) {
                e.setState(currentState);
            }
            if (event != null) {
                e.setEvent(event);
            }
            if (mementos != null) {
                e.setMementos(mementos);
            }
            throw e;
        }
        finally {
            if (mementos != null) {
                mementos.touch();
            }
        }
        if (mementos.empty()) {
            this.deleteMementos(request, flowId);
        }
        if (mav != null && !mementos.empty()) {
            mav.addObject(this.getFlowIdModelName(), (Object)flowId);
            mav.addObject(this.getCurrentStateModelName(), (Object)mementos.getCurrentState());
        }
        return mav;
    }

    protected WebFlow getWebFlow(String flowName) {
        return (WebFlow)this.getWebApplicationContext().getBean(flowName);
    }

    protected String getParameter(HttpServletRequest request, String paramName) {
        return this.parameterExtractor.extractParameter(request, paramName);
    }

    protected String generateId() {
        return WebFlowUtils.generateUniqueId();
    }

    protected WebFlowMementoStack createMementos(String flowName, String id) {
        WebFlowMementoStack mementos = new WebFlowMementoStack();
        mementos.push(new WebFlowMemento(flowName));
        mementos.getModel().put(this.getFlowIdModelName(), id);
        return mementos;
    }

    protected WebFlowMementoStack loadMementos(HttpServletRequest request, String id) {
        return (WebFlowMementoStack)request.getSession().getAttribute(id);
    }

    protected void saveMementos(HttpServletRequest request, String id, WebFlowMementoStack mementos) {
        request.getSession().setAttribute(id, (Object)mementos);
    }

    protected void deleteMementos(HttpServletRequest request, String id) {
        request.getSession().removeAttribute(id);
    }
}

