/*
 * Decompiled with CFR 0.152.
 */
package com.ervacon.springframework.web.servlet.mvc.webflow;

import com.ervacon.springframework.web.servlet.mvc.webflow.WebFlow;
import com.ervacon.springframework.web.servlet.mvc.webflow.WebFlowMemento;
import java.io.Serializable;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

public class WebFlowMementoStack
implements Serializable {
    private Stack mementos = new Stack();
    private long lastAccessedTime = System.currentTimeMillis();

    public boolean empty() {
        return this.mementos.empty();
    }

    public int size() {
        return this.mementos.size();
    }

    public void push(WebFlowMemento memento) {
        this.mementos.push(memento);
    }

    public WebFlowMemento peek() throws EmptyStackException {
        return (WebFlowMemento)this.mementos.peek();
    }

    public WebFlowMemento pop() {
        try {
            return (WebFlowMemento)this.mementos.pop();
        }
        catch (EmptyStackException e) {
            return null;
        }
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public void touch() {
        this.lastAccessedTime = System.currentTimeMillis();
    }

    public List asList() {
        return Collections.unmodifiableList(this.mementos);
    }

    public String getFlowName() {
        return this.peek().getFlowName();
    }

    public WebFlow getFlow(ApplicationContext appCtx) throws BeansException {
        return this.peek().getFlow(appCtx);
    }

    public String getCurrentState() {
        return this.peek().getCurrentState();
    }

    public void setCurrentState(String state) {
        this.peek().setCurrentState(state);
    }

    public Map getModel() {
        return this.peek().getModel();
    }
}

