/*
 * Decompiled with CFR 0.152.
 */
package com.ervacon.springframework.web.servlet.mvc.webflow;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class WebFlowUtils {
    private WebFlowUtils() {
    }

    public static String generateUniqueId() {
        StringBuffer id = new StringBuffer();
        id.append(System.currentTimeMillis());
        id.append((int)(Math.random() * 1.0E8));
        while (id.length() < 20) {
            id.append('0');
        }
        return id.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveToken(Map model, String tokenName) {
        String token = WebFlowUtils.generateUniqueId();
        Map map = model;
        synchronized (map) {
            model.put(tokenName, token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetToken(Map model, String tokenName) {
        Map map = model;
        synchronized (map) {
            model.remove(tokenName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTokenValid(Map model, String tokenName, HttpServletRequest request, String requestTokenName, boolean reset) {
        Map map = model;
        synchronized (map) {
            String requestToken;
            String modelToken = (String)model.get(tokenName);
            if (modelToken == null) {
                return false;
            }
            if (reset) {
                WebFlowUtils.resetToken(model, tokenName);
            }
            if ((requestToken = request.getParameter(requestTokenName)) == null) {
                return false;
            }
            return modelToken.equals(requestToken);
        }
    }
}

