/*
 * Decompiled with CFR 0.152.
 */
package es.blackleg.jlibnotify.core;

import com.sun.jna.Pointer;
import es.blackleg.jlibnotify.LibNotify;
import es.blackleg.jlibnotify.Notification;
import es.blackleg.jlibnotify.ServerInfo;
import es.blackleg.jlibnotify.core.BasicNotification;
import es.blackleg.jlibnotify.core.BasicServerInfo;
import es.blackleg.jlibnotify.core.ServerCapabilitiesReader;
import es.blackleg.jlibnotify.jna.GBoolean;
import es.blackleg.jlibnotify.jna.NativeLibNotify;
import java.util.Collection;

public class DefaultLibNotify
implements LibNotify {
    private final NativeLibNotify nativeLibNotify;
    private final ServerCapabilitiesReader serverCapabilitiesReader;

    public DefaultLibNotify(NativeLibNotify libNotify, ServerCapabilitiesReader serverCapabilitiesReader) {
        this.nativeLibNotify = libNotify;
        this.serverCapabilitiesReader = serverCapabilitiesReader;
    }

    @Override
    public void init(String appName) {
        if (this.nativeLibNotify.notify_init(appName) == GBoolean.FALSE) {
            throw new RuntimeException("Error when init libnotify");
        }
    }

    @Override
    public boolean isAvailable() {
        return this.nativeLibNotify.notify_is_initted() == GBoolean.TRUE;
    }

    @Override
    public void unInit() {
        this.nativeLibNotify.notify_uninit();
    }

    @Override
    public String getAppName() {
        return this.nativeLibNotify.notify_get_app_name();
    }

    @Override
    public void setAppName(String appName) {
        this.nativeLibNotify.notify_set_app_name(appName);
    }

    @Override
    public ServerInfo getServerInfo() {
        String[] name = new String[1];
        String[] vendor = new String[1];
        String[] version = new String[1];
        String[] specVersion = new String[1];
        if (this.nativeLibNotify.notify_get_server_info(name, vendor, version, specVersion) == GBoolean.FALSE) {
            throw new RuntimeException("Error when get server info");
        }
        return new BasicServerInfo(name[0], vendor[0], version[0], specVersion[0]);
    }

    @Override
    public Collection<String> getServerCapabilities() {
        return this.serverCapabilitiesReader.getServerCapabilitiesFromPointer(this.nativeLibNotify.notify_get_server_caps());
    }

    @Override
    public Notification createNotification(String summary, String body, String icon) {
        Pointer pointer = this.nativeLibNotify.notify_notification_new(summary, body, icon);
        return new BasicNotification(pointer, summary, body, icon);
    }

    @Override
    public void showNotification(Notification notification) {
        if (this.nativeLibNotify.notify_notification_show(notification.getPointer(), Pointer.NULL) == GBoolean.FALSE) {
            throw new RuntimeException("Error when show notification");
        }
    }

    @Override
    public void updateNotification(Notification notification, String summary, String body, String icon) {
        if (this.nativeLibNotify.notify_notification_update(notification.getPointer(), summary, body, icon) == GBoolean.FALSE) {
            throw new RuntimeException("Error when showing notification");
        }
    }

    @Override
    public void setTimeOut(Notification notification, int timeout) {
        this.nativeLibNotify.notify_notification_set_timeout(notification.getPointer(), timeout);
    }

    @Override
    public void closeNotification(Notification notification) {
        if (this.nativeLibNotify.notify_notification_close(notification.getPointer(), Pointer.NULL) == GBoolean.FALSE) {
            throw new RuntimeException("Error when show notification");
        }
    }
}

