/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.cert.certvalidation;

import es.gob.afirma.cert.certvalidation.CertificateVerificable;
import es.gob.afirma.cert.certvalidation.ValidationResult;
import es.gob.afirma.core.misc.AOUtil;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Logger;

public abstract class CertificateVerifier
implements CertificateVerificable {
    protected static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private X509Certificate certificate = null;
    private final Properties conf = new Properties();
    private X509Certificate issuerCert;

    @Override
    public void setSubjectCert(X509Certificate x509Certificate) {
        this.certificate = x509Certificate;
    }

    protected X509Certificate getCertificate() {
        return this.certificate;
    }

    protected Properties getValidationProperties() {
        return this.conf;
    }

    @Override
    public void setValidationProperties(String string) {
        if (string == null) {
            LOGGER.warning("No hay configuracion especifica de validacion, se usaran los valores por defecto");
            return;
        }
        try {
            this.conf.load(CertificateVerifier.class.getResourceAsStream(string));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("No se ha podido cargar la configuracion del verificador (" + string + ": " + exception, exception);
        }
        String string2 = this.conf.getProperty("issuerCertFile");
        if (string2 != null) {
            try {
                this.setIssuerCert((X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(CertificateVerifier.class.getResourceAsStream(string2)));
            }
            catch (CertificateException certificateException) {
                throw new IllegalArgumentException("No se ha podido cargar el certificado raiz del emisor (" + string2 + "): " + certificateException, certificateException);
            }
        }
    }

    @Override
    public void setIssuerCert(X509Certificate x509Certificate) {
        this.issuerCert = x509Certificate;
    }

    protected X509Certificate getIssuerCert() {
        return this.issuerCert;
    }

    @Override
    public ValidationResult validateCertificate() {
        return this.validateCertificate(this.certificate);
    }

    @Override
    public abstract ValidationResult verifyRevocation(X509Certificate var1);

    @Override
    public void verifyIssuer(X509Certificate x509Certificate) throws CertificateException, SignatureException {
        if (x509Certificate == null) {
            throw new CertificateException("Se ha proporcionado un certificado nulo");
        }
        if (!this.issuerCert.getSubjectX500Principal().toString().equals(x509Certificate.getIssuerX500Principal().toString())) {
            LOGGER.info("El certificado proporcionado no esta emitido por '" + this.issuerCert.getSubjectX500Principal() + "', sino por '" + x509Certificate.getIssuerX500Principal() + "'");
            throw new SignatureException("El certificado proporcionado no esta emitido por '" + this.issuerCert.getSubjectX500Principal() + "', sino por '" + x509Certificate.getIssuerX500Principal() + "'");
        }
        LOGGER.info("El certificado a validar ha sido emitido por: " + AOUtil.getCN((String)x509Certificate.getIssuerX500Principal().toString()));
        try {
            x509Certificate.verify(this.issuerCert.getPublicKey());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CertificateException(invalidKeyException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CertificateException(noSuchAlgorithmException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new CertificateException(noSuchProviderException);
        }
    }

    @Override
    public ValidationResult validateCertificate(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            LOGGER.warning("Se ha proporcionado un certificado a validar nulo");
            return ValidationResult.CORRUPT;
        }
        if (new Date().after(x509Certificate.getNotAfter())) {
            LOGGER.info("Se ha proporcionado un certificado que caduco en: " + x509Certificate.getNotAfter());
            return ValidationResult.EXPIRED;
        }
        if (new Date().before(x509Certificate.getNotBefore())) {
            LOGGER.info("Se ha proporcionado un certificado que aun no es valido, lo sera a partir de: " + x509Certificate.getNotBefore());
            return ValidationResult.NOT_YET_VALID;
        }
        if (this.issuerCert != null) {
            try {
                this.verifyIssuer(x509Certificate);
            }
            catch (SignatureException signatureException) {
                return ValidationResult.CA_NOT_SUPPORTED;
            }
            catch (Exception exception) {
                LOGGER.severe("Error durante la verificacion del emisor del certificado: " + exception);
                return ValidationResult.SERVER_ERROR;
            }
        }
        return this.verifyRevocation(x509Certificate);
    }
}

