/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.cert.certvalidation;

import es.gob.afirma.cert.certvalidation.CertificateVerificable;
import es.gob.afirma.cert.certvalidation.CertificateVerifierFactoryException;
import es.gob.afirma.cert.certvalidation.CrlCertificateVerifier;
import es.gob.afirma.cert.certvalidation.OcspCertificateVerifier;
import java.security.cert.X509Certificate;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.zip.CRC32;

public final class CertificateVerifierFactory {
    private static Properties p = null;
    private static final String FACTORY_CONFIGURATION = "/validationfactory.properties";
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");

    private CertificateVerifierFactory() {
    }

    private static String getIssuerIdentifier(X509Certificate x509Certificate) {
        CRC32 cRC32 = new CRC32();
        cRC32.update(x509Certificate.getIssuerX500Principal().getEncoded());
        long l = cRC32.getValue();
        cRC32.reset();
        cRC32.update(x509Certificate.getSigAlgName().getBytes());
        return Long.toHexString(l + cRC32.getValue());
    }

    public static CertificateVerificable getCertificateVerifier(X509Certificate x509Certificate) throws CertificateVerifierFactoryException {
        CertificateVerificable certificateVerificable;
        if (x509Certificate == null) {
            throw new IllegalArgumentException("El certificado no puede ser nulo");
        }
        if (p == null) {
            p = new Properties();
            try {
                p.load(CertificateVerifierFactory.class.getResourceAsStream(FACTORY_CONFIGURATION));
            }
            catch (Exception exception) {
                p = null;
                throw new IllegalStateException("No se ha podido cargar la configuracion de la factoria: " + exception, exception);
            }
        }
        String string = CertificateVerifierFactory.getIssuerIdentifier(x509Certificate);
        LOGGER.info("Identificador del emisor del certificado: " + string);
        String string2 = p.getProperty(string + ".validation.type");
        if (p.getProperty(string + ".validation.properties") == null) {
            string = "default";
        }
        String string3 = p.getProperty(string + ".validation.properties");
        if ("ocsp".equalsIgnoreCase(string2)) {
            certificateVerificable = new OcspCertificateVerifier();
        } else if ("crl".equalsIgnoreCase(string2) || string2 == null) {
            certificateVerificable = new CrlCertificateVerifier();
        } else {
            try {
                Class<?> clazz = Class.forName(string2);
                certificateVerificable = (CertificateVerificable)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOGGER.warning("No se encuentra la clase validadora: " + classNotFoundException);
                throw new CertificateVerifierFactoryException("No se encuentran la clase validadora: " + classNotFoundException, classNotFoundException);
            }
            catch (Exception exception) {
                LOGGER.warning("No se ha podido instanciar el verificador del certificado: " + exception);
                throw new CertificateVerifierFactoryException("No se ha podido instanciar el verificador del certificado: " + exception, exception);
            }
        }
        certificateVerificable.setValidationProperties(string3);
        certificateVerificable.setSubjectCert(x509Certificate);
        return certificateVerificable;
    }
}

