/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.cert.certvalidation;

import es.gob.afirma.cert.certvalidation.ValidationResult;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.http.DataDownloader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PublicKey;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.InitialDirContext;

final class CrlHelper {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");

    private CrlHelper() {
    }

    static ValidationResult verifyCertificateCRLs(X509Certificate x509Certificate, PublicKey publicKey, List<String> list) {
        CertificateFactory certificateFactory;
        List<String> list2;
        if (x509Certificate == null) {
            return ValidationResult.CORRUPT;
        }
        try {
            list2 = list == null || list.isEmpty() ? CrlHelper.getCrlDistributionPoints(x509Certificate) : list;
        }
        catch (IOException iOException) {
            LOGGER.severe("Error obteniendo los puntos de distribucion de CRL: " + iOException);
            return ValidationResult.SERVER_ERROR;
        }
        if (list2 == null || list2.isEmpty()) {
            LOGGER.warning("El certificado con serie '" + x509Certificate.getSerialNumber() + "' no tiene CRL asociadas");
            return ValidationResult.UNKNOWN;
        }
        LOGGER.info("El certificado con serie '" + x509Certificate.getSerialNumber() + "' tiene asociadas las siguientes CRL: " + list2);
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            LOGGER.severe("Error instanciando la factoria de certificados: " + certificateException);
            return ValidationResult.SERVER_ERROR;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (String string : list2) {
            X509CRL x509CRL;
            byte[] byArray;
            try {
                byArray = CrlHelper.downloadCRL(string);
            }
            catch (Exception exception) {
                LOGGER.severe("No se ha podido descargar la CRL (" + string + "), se continuara con el siguiente punto de distribucion: " + exception);
                bl2 = true;
                continue;
            }
            try {
                x509CRL = (X509CRL)certificateFactory.generateCRL(new ByteArrayInputStream(byArray));
            }
            catch (Exception exception) {
                LOGGER.severe("Error analizando la lista de revocacion: " + exception);
                return ValidationResult.SERVER_ERROR;
            }
            if (publicKey != null) {
                try {
                    x509CRL.verify(publicKey);
                }
                catch (Exception exception) {
                    LOGGER.severe("No se ha podido comprobar la firma de la CRL: " + exception);
                    return ValidationResult.SERVER_ERROR;
                }
            }
            if (x509CRL.isRevoked(x509Certificate)) {
                return ValidationResult.REVOKED;
            }
            bl = true;
        }
        if (bl) {
            return ValidationResult.VALID;
        }
        if (bl2) {
            return ValidationResult.CANNOT_DOWNLOAD_CRL;
        }
        return ValidationResult.UNKNOWN;
    }

    private static byte[] downloadCRL(String string) throws CRLException, IOException, NamingException, URISyntaxException {
        if (string.startsWith("http://") || string.startsWith("https://") || string.startsWith("ftp://")) {
            return CrlHelper.downloadCRLFromWeb(string);
        }
        if (string.startsWith("ldap://")) {
            return CrlHelper.downloadCRLFromLDAP(string);
        }
        if (string.startsWith("file:/")) {
            return CrlHelper.downloadCRLFromFile(string);
        }
        throw new CRLException("No se soporta el protocolo del punto de distribucion de CRL: " + string);
    }

    private static byte[] downloadCRLFromFile(String string) throws IOException, URISyntaxException {
        return AOUtil.getDataFromInputStream((InputStream)AOUtil.loadFile((URI)new URI(string)));
    }

    private static byte[] downloadCRLFromLDAP(String string) throws NamingException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        hashtable.put("java.naming.provider.url", string);
        Attribute attribute = new InitialDirContext(hashtable).getAttributes("").get("certificateRevocationList;binary");
        byte[] byArray = (byte[])attribute.get();
        if (byArray == null || byArray.length == 0) {
            throw new NamingException("No se ha podido descargar la CRL desde " + string);
        }
        return byArray;
    }

    private static byte[] downloadCRLFromWeb(String string) throws IOException {
        return DataDownloader.downloadData((String)string);
    }

    /*
     * Exception decompiling
     */
    private static List<String> getCrlDistributionPoints(X509Certificate var0) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

