/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.cert.certvalidation;

import es.gob.afirma.cert.certvalidation.CertificateVerifier;
import es.gob.afirma.cert.certvalidation.OcspHelper;
import es.gob.afirma.cert.certvalidation.ValidationResult;
import java.net.URL;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.List;

public final class OcspCertificateVerifier
extends CertificateVerifier {
    @Override
    public void setSubjectCert(X509Certificate x509Certificate) {
        super.setSubjectCert(x509Certificate);
        if (this.getValidationProperties() != null) {
            try {
                this.getValidationProperties().setProperty("responderUrl", OcspCertificateVerifier.getBestResponder(OcspHelper.getAIALocations(x509Certificate)));
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception);
            }
            this.getValidationProperties().setProperty("signOcspRequest", "false");
        }
    }

    @Override
    public ValidationResult verifyRevocation(X509Certificate x509Certificate) {
        byte[] byArray;
        byte[] byArray2;
        Object object;
        if (Boolean.parseBoolean(this.getValidationProperties().getProperty("signOcspRequest"))) {
            try {
                object = OcspHelper.getSignData(this.getValidationProperties().getProperty("signStore"), this.getValidationProperties().getProperty("signStorePass"), this.getValidationProperties().getProperty("signAlias"));
            }
            catch (Exception exception) {
                LOGGER.severe("Error obteniendo los datos de firma de peticiones OCSP: " + exception);
                return ValidationResult.SERVER_ERROR;
            }
            try {
                byArray2 = OcspHelper.createSignedOcspRequest(x509Certificate, this.getIssuerCert(), (KeyStore.PrivateKeyEntry)object);
            }
            catch (Exception exception) {
                LOGGER.severe("Error creando la peticion OCSP firmada: " + exception);
                return ValidationResult.SERVER_ERROR;
            }
        }
        try {
            byArray2 = OcspHelper.createOcspRequest(x509Certificate, this.getIssuerCert());
        }
        catch (Exception exception) {
            LOGGER.severe("Error creando la peticion OCSP: " + exception);
            return ValidationResult.SERVER_ERROR;
        }
        try {
            object = new URL(this.getValidationProperties().getProperty("responderUrl"));
        }
        catch (Exception exception) {
            LOGGER.severe("No se ha configurado una URL de servicio OCSP valida: " + exception);
            return ValidationResult.SERVER_ERROR;
        }
        LOGGER.info("Se usara el siguiente OCSP para validar el certificado: " + object);
        try {
            byArray = OcspHelper.sendOcspRequest((URL)object, byArray2);
        }
        catch (Exception exception) {
            LOGGER.severe("Error enviado la peticion OCSP al servidor (" + object + "): " + exception);
            return ValidationResult.SERVER_ERROR;
        }
        try {
            return OcspHelper.analyzeOcspResponse(byArray);
        }
        catch (Exception exception) {
            LOGGER.severe("Error analizando la respuesta del servidor OCSP: " + exception);
            return ValidationResult.SERVER_ERROR;
        }
    }

    private static String getBestResponder(List<String> list) {
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("No hay servidores OCSP configurados");
        }
        String string = list.get(0);
        if (list.size() > 1) {
            for (int i = 1; i < list.size(); ++i) {
                if (!list.get(i).toLowerCase().contains("ocsp")) continue;
                string = list.get(i);
            }
        }
        return string;
    }
}

