/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.cert.certvalidation;

import es.gob.afirma.cert.certvalidation.ValidationResult;
import es.gob.afirma.core.misc.AOUtil;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import org.spongycastle.asn1.x500.X500Name;
import org.spongycastle.asn1.x509.AlgorithmIdentifier;
import org.spongycastle.cert.X509CertificateHolder;
import org.spongycastle.cert.jcajce.JcaX509CertificateHolder;
import org.spongycastle.cert.ocsp.BasicOCSPResp;
import org.spongycastle.cert.ocsp.CertificateID;
import org.spongycastle.cert.ocsp.CertificateStatus;
import org.spongycastle.cert.ocsp.OCSPException;
import org.spongycastle.cert.ocsp.OCSPReqBuilder;
import org.spongycastle.cert.ocsp.OCSPResp;
import org.spongycastle.cert.ocsp.RespID;
import org.spongycastle.cert.ocsp.RevokedStatus;
import org.spongycastle.cert.ocsp.SingleResp;
import org.spongycastle.cert.ocsp.UnknownStatus;
import org.spongycastle.jce.provider.BouncyCastleProvider;
import org.spongycastle.operator.DigestCalculator;
import org.spongycastle.operator.OperatorCreationException;
import org.spongycastle.operator.jcajce.JcaContentSignerBuilder;

final class OcspHelper {
    private OcspHelper() {
    }

    static KeyStore.PrivateKeyEntry getSignData(String string, String string2, String string3) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableEntryException {
        if (string == null) {
            throw new IllegalArgumentException("Debe indicarse un nombre de almacen PKCS#12");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Debe indicarse una contrasena para el almacen PKCS#12");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("Debe indicarse un alias de certificado contenido en el almacen PKCS#12");
        }
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        keyStore.load(OcspHelper.class.getResourceAsStream(string), string2.toCharArray());
        if (!keyStore.containsAlias(string3)) {
            throw new IllegalArgumentException("El almacen proporcionado no contiene ninguna entrada con el alias: " + string3);
        }
        return (KeyStore.PrivateKeyEntry)keyStore.getEntry(string3, new KeyStore.PasswordProtection(string2.toCharArray()));
    }

    static byte[] sendOcspRequest(URL uRL, byte[] byArray) throws IOException {
        Object object;
        if (uRL == null) {
            throw new IllegalArgumentException("La URL del servicio OCSP no puede ser nula");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("La peticion OCSP no puede ser nula");
        }
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setRequestProperty("Content-Type", "application/ocsp-request");
        httpURLConnection.setRequestProperty("Accept", "application/ocsp-response");
        try (Closeable closeable = httpURLConnection.getOutputStream();){
            object = new DataOutputStream(new BufferedOutputStream((OutputStream)closeable));
            Throwable throwable = null;
            try {
                ((FilterOutputStream)object).write(byArray);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((FilterOutputStream)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((FilterOutputStream)object).close();
                    }
                }
            }
        }
        if (httpURLConnection.getResponseCode() / 100 != 2) {
            throw new IOException("El servidor OCSP ha devuelto un codigo de error " + httpURLConnection.getResponseCode());
        }
        closeable = (InputStream)httpURLConnection.getContent();
        var4_4 = null;
        try {
            object = AOUtil.getDataFromInputStream((InputStream)closeable);
            return object;
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (closeable != null) {
                if (var4_4 != null) {
                    try {
                        ((InputStream)closeable).close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    ((InputStream)closeable).close();
                }
            }
        }
    }

    static byte[] createOcspRequest(X509Certificate x509Certificate, X509Certificate x509Certificate2) throws CertificateEncodingException, NoSuchAlgorithmException, OCSPException, IOException {
        CertificateID certificateID = new CertificateID((DigestCalculator)new Sha1DigestCalculator(), (X509CertificateHolder)new JcaX509CertificateHolder(x509Certificate2 != null ? x509Certificate2 : x509Certificate), x509Certificate.getSerialNumber());
        OCSPReqBuilder oCSPReqBuilder = new OCSPReqBuilder();
        oCSPReqBuilder.addRequest(certificateID);
        return oCSPReqBuilder.build().getEncoded();
    }

    static byte[] createSignedOcspRequest(X509Certificate x509Certificate, X509Certificate x509Certificate2, KeyStore.PrivateKeyEntry privateKeyEntry) throws CertificateEncodingException, NoSuchAlgorithmException, OCSPException, OperatorCreationException, IOException {
        CertificateID certificateID = new CertificateID((DigestCalculator)new Sha1DigestCalculator(), (X509CertificateHolder)new JcaX509CertificateHolder(x509Certificate2), x509Certificate.getSerialNumber());
        OCSPReqBuilder oCSPReqBuilder = new OCSPReqBuilder();
        oCSPReqBuilder.addRequest(certificateID);
        oCSPReqBuilder.setRequestorName(new X500Name(((X509Certificate)privateKeyEntry.getCertificate()).getSubjectX500Principal().toString()));
        return oCSPReqBuilder.build(new JcaContentSignerBuilder("SHA1withRSA").build(privateKeyEntry.getPrivateKey()), new X509CertificateHolder[]{new JcaX509CertificateHolder((X509Certificate)privateKeyEntry.getCertificate())}).getEncoded();
    }

    static ValidationResult analyzeOcspResponse(byte[] byArray) throws OCSPException, IOException {
        if (byArray == null) {
            throw new IOException("La respuesta OCSP es nula");
        }
        OCSPResp oCSPResp = new OCSPResp(byArray);
        if (oCSPResp.getStatus() == 0) {
            SingleResp[] singleRespArray = ((BasicOCSPResp)oCSPResp.getResponseObject()).getResponses();
            CertificateStatus certificateStatus = singleRespArray[0].getCertStatus();
            if (certificateStatus == CertificateStatus.GOOD) {
                return ValidationResult.VALID;
            }
            if (certificateStatus instanceof RevokedStatus) {
                return ValidationResult.REVOKED;
            }
            if (certificateStatus instanceof UnknownStatus) {
                return ValidationResult.UNKNOWN;
            }
            throw new IllegalArgumentException("La validacion ha devuelto una respuesta desconocida: " + certificateStatus.getClass().getName());
        }
        if (oCSPResp.getStatus() == 6) {
            return ValidationResult.UNAUTHORIZED;
        }
        if (oCSPResp.getStatus() == 2 || oCSPResp.getStatus() == 3) {
            return ValidationResult.SERVER_ERROR;
        }
        if (oCSPResp.getStatus() == 1) {
            return ValidationResult.MALFORMED_REQUEST;
        }
        if (oCSPResp.getStatus() == 5) {
            return ValidationResult.SIG_REQUIRED;
        }
        throw new IllegalArgumentException("La validacion ha devuelto un estado desconocido: " + oCSPResp.getStatus());
    }

    /*
     * Exception decompiling
     */
    static List<String> getAIALocations(X509Certificate var0) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    private static class Sha1DigestCalculator
    implements DigestCalculator {
        private final ByteArrayOutputStream baos = new ByteArrayOutputStream();
        private final MessageDigest digest = MessageDigest.getInstance("SHA-1");

        Sha1DigestCalculator() throws NoSuchAlgorithmException {
        }

        public OutputStream getOutputStream() {
            return this.baos;
        }

        public byte[] getDigest() {
            byte[] byArray = this.digest.digest(this.baos.toByteArray());
            this.baos.reset();
            return byArray;
        }

        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return RespID.HASH_SHA1;
        }
    }
}

