/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.cert.certvalidation;

import es.gob.afirma.cert.certvalidation.CertValidationMessages;
import es.gob.afirma.cert.certvalidation.CertificateCannotDownloadCrlException;
import es.gob.afirma.cert.certvalidation.CertificateMalformedOcspRequestException;
import es.gob.afirma.cert.certvalidation.CertificateRevokedException;
import es.gob.afirma.cert.certvalidation.CertificateServerErrorException;
import es.gob.afirma.cert.certvalidation.CertificateUnauthorizedException;
import es.gob.afirma.cert.certvalidation.CertificateUnknownStatusException;
import es.gob.afirma.cert.certvalidation.CertificateUnsignedOcspRequestException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;

public enum ValidationResult {
    VALID(0),
    CORRUPT(1),
    CA_NOT_SUPPORTED(2),
    NOT_YET_VALID(3),
    EXPIRED(4),
    REVOKED(5),
    UNKNOWN(6),
    SERVER_ERROR(7),
    UNAUTHORIZED(8),
    MALFORMED_REQUEST(9),
    SIG_REQUIRED(10),
    CANNOT_DOWNLOAD_CRL(11);

    private static final int CODE_VALID = 0;
    private static final int CODE_CORRUPT = 1;
    private static final int CODE_CA_NOT_SUPPORTED = 2;
    private static final int CODE_NOT_YET_VALID = 3;
    private static final int CODE_EXPIRED = 4;
    private static final int CODE_REVOKED = 5;
    private static final int CODE_UNKNOWN = 6;
    private static final int CODE_SERVER_ERROR = 7;
    private static final int CODE_UNAUTHORIZED = 8;
    private static final int CODE_MALFORMED_REQUEST = 9;
    private static final int CODE_SIG_REQUIRED = 10;
    private static final int CODE_CANNOT_DOWNLOAD_CRL = 11;
    private final int resultCode;

    private ValidationResult(int n2) {
        if (n2 < 0 || n2 > 11) {
            throw new IllegalArgumentException("El codigo de resultado debe estar comprendido entre 0 y 11: " + n2);
        }
        this.resultCode = n2;
    }

    public String toJsonString() {
        return "{\n" + "  \"result\": \"" + (this.isValid() ? "OK" : "KO") + "\",\n" + "  \"reason\": \"" + this.toString() + "\"\n" + "}";
    }

    public boolean isValid() {
        return this.resultCode == 0;
    }

    public String toString() {
        switch (this.resultCode) {
            case 0: {
                return CertValidationMessages.getString("ValidationResult.0");
            }
            case 1: {
                return CertValidationMessages.getString("ValidationResult.1");
            }
            case 2: {
                return CertValidationMessages.getString("ValidationResult.2");
            }
            case 3: {
                return CertValidationMessages.getString("ValidationResult.3");
            }
            case 4: {
                return CertValidationMessages.getString("ValidationResult.4");
            }
            case 5: {
                return CertValidationMessages.getString("ValidationResult.5");
            }
            case 6: {
                return CertValidationMessages.getString("ValidationResult.6");
            }
            case 7: {
                return CertValidationMessages.getString("ValidationResult.7");
            }
            case 8: {
                return CertValidationMessages.getString("ValidationResult.8");
            }
            case 9: {
                return CertValidationMessages.getString("ValidationResult.9");
            }
            case 10: {
                return CertValidationMessages.getString("ValidationResult.10");
            }
            case 11: {
                return CertValidationMessages.getString("ValidationResult.11");
            }
        }
        throw new IllegalStateException("El codigo de resultado debe estar comprendido entre 0 y 11: " + this.resultCode);
    }

    public void check() throws CertificateException {
        switch (this.resultCode) {
            case 0: {
                return;
            }
            case 1: {
                throw new CertificateEncodingException();
            }
            case 2: {
                throw new CertificateException("El certificado no es de una CA soportada");
            }
            case 3: {
                throw new CertificateNotYetValidException();
            }
            case 4: {
                throw new CertificateExpiredException();
            }
            case 5: {
                throw new CertificateRevokedException("Certificado revocado");
            }
            case 6: {
                throw new CertificateUnknownStatusException("Validez del certificado desconocida");
            }
            case 7: {
                throw new CertificateServerErrorException("Error interno o del servidor al validar el certificado");
            }
            case 8: {
                throw new CertificateUnauthorizedException("No autorizado");
            }
            case 9: {
                throw new CertificateMalformedOcspRequestException("Peticion OCSP mal formada");
            }
            case 10: {
                throw new CertificateUnsignedOcspRequestException("La peticion OCSP no esta firmada");
            }
            case 11: {
                throw new CertificateCannotDownloadCrlException("No se ha podido descargar la lista de certificados revocados");
            }
        }
        throw new IllegalStateException("El codigo de resultado debe estar comprendido entre 0 y 11: " + this.resultCode);
    }
}

