/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.cert.signvalidation;

import es.gob.afirma.core.misc.AOFileUtils;
import es.gob.afirma.core.misc.Base64;
import es.gob.afirma.signers.cades.AOCAdESSigner;
import es.gob.afirma.signers.cms.AOCMSSigner;
import es.gob.afirma.signers.odf.AOODFSigner;
import es.gob.afirma.signers.ooxml.AOOOXMLSigner;
import es.gob.afirma.signers.pades.AOPDFSigner;
import es.gob.afirma.signers.xades.AOFacturaESigner;
import es.gob.afirma.signers.xades.AOXAdESSigner;
import es.gob.afirma.signers.xmldsig.AOXMLDSigSigner;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class DataAnalizerUtil {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");

    private DataAnalizerUtil() {
    }

    public static X509Certificate isCertificate(byte[] byArray) throws CertificateException {
        if (byArray == null || byArray.length < 1) {
            throw new CertificateException("Los datos eran nulos o vacios");
        }
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        try {
            return (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
        }
        catch (Exception exception) {
            try {
                return (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(Base64.decode((String)new String(byArray).replace("%0A", "").replace("%2F", "/").replace("%2B", "+").replace("%3D", "="))));
            }
            catch (Exception exception2) {
                throw new CertificateException("Los datos proporcionados no son un certificado X.509");
            }
        }
    }

    public static boolean isXML(byte[] byArray) {
        return AOFileUtils.isXML((byte[])byArray);
    }

    public static boolean isSignedXML(byte[] byArray) {
        try {
            return new AOXAdESSigner().isSign(byArray) || new AOXMLDSigSigner().isSign(byArray);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isPDF(byte[] byArray) {
        try {
            return new AOPDFSigner().isValidDataFile(byArray);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isSignedPDF(byte[] byArray) {
        try {
            return new AOPDFSigner().isSign(byArray);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isBinary(byte[] byArray) {
        try {
            return new AOCMSSigner().isValidDataFile(byArray);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isSignedBinary(byte[] byArray) {
        try {
            return new AOCMSSigner().isSign(byArray) || new AOCAdESSigner().isSign(byArray);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isFacturae(byte[] byArray) {
        try {
            return new AOFacturaESigner().isValidDataFile(byArray);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isSignedFacturae(byte[] byArray) {
        try {
            return new AOFacturaESigner().isSign(byArray);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isODF(byte[] byArray) {
        try {
            return new AOODFSigner().isValidDataFile(byArray);
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Ocurrio un error al analizar los datos: " + exception);
            return false;
        }
    }

    public static boolean isSignedODF(byte[] byArray) {
        try {
            return new AOODFSigner().isSign(byArray);
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Ocurrio un error al analizar los datos: " + exception);
            return false;
        }
    }

    public static boolean isOOXML(byte[] byArray) {
        try {
            return new AOOOXMLSigner().isValidDataFile(byArray);
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Ocurrio un error al analizar los datos: " + exception);
            return false;
        }
    }

    public static boolean isSignedOOXML(byte[] byArray) {
        try {
            return new AOOOXMLSigner().isSign(byArray);
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Ocurrio un error al analizar los datos: " + exception);
            return false;
        }
    }
}

