/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.cert.signvalidation;

import es.gob.afirma.cert.signvalidation.DataAnalizerUtil;
import es.gob.afirma.cert.signvalidation.SignValider;
import java.util.logging.Logger;

public final class SignValiderFactory {
    private static final String SIGNER_VALIDER_CLASS_BINARY = "es.gob.afirma.cert.signvalidation.ValidateBinarySignature";
    private static final String SIGNER_VALIDER_CLASS_PDF = "es.gob.afirma.cert.signvalidation.ValidatePdfSignature";
    private static final String SIGNER_VALIDER_CLASS_XML = "es.gob.afirma.cert.signvalidation.ValidateXMLSignature";

    private SignValiderFactory() {
    }

    public static SignValider getSignValider(byte[] byArray) throws IllegalArgumentException {
        String string;
        if (byArray == null || byArray.length < 1) {
            throw new IllegalArgumentException("No se han indicado datos de firma");
        }
        if (DataAnalizerUtil.isPDF(byArray)) {
            string = SIGNER_VALIDER_CLASS_PDF;
        } else if (DataAnalizerUtil.isFacturae(byArray)) {
            string = SIGNER_VALIDER_CLASS_XML;
        } else if (DataAnalizerUtil.isXML(byArray)) {
            string = SIGNER_VALIDER_CLASS_XML;
        } else {
            if (DataAnalizerUtil.isOOXML(byArray)) {
                Logger.getLogger("es.gob.afirma").warning("No hay un validador para OOXML");
                return null;
            }
            if (DataAnalizerUtil.isODF(byArray)) {
                Logger.getLogger("es.gob.afirma").warning("No hay un validador para ODF");
                return null;
            }
            string = SIGNER_VALIDER_CLASS_BINARY;
        }
        try {
            return (SignValider)Class.forName(string).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            Logger.getLogger("es.gob.afirma").severe("No se ha podido instanciar el validador '" + string + "': " + exception);
            return null;
        }
    }
}

