/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.cert.signvalidation;

import com.aowagie.text.pdf.AcroFields;
import com.aowagie.text.pdf.PdfDictionary;
import com.aowagie.text.pdf.PdfName;
import com.aowagie.text.pdf.PdfPKCS7;
import com.aowagie.text.pdf.PdfReader;
import es.gob.afirma.cert.signvalidation.SignValider;
import es.gob.afirma.cert.signvalidation.SignValidity;
import java.io.IOException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.logging.Logger;

public final class ValidatePdfSignature
implements SignValider {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final PdfName PDFNAME_ETSI_RFC3161 = new PdfName("ETSI.RFC3161");
    private static final PdfName PDFNAME_DOCTIMESTAMP = new PdfName("DocTimeStamp");

    @Override
    public SignValidity validate(byte[] byArray) throws IOException {
        PdfReader pdfReader = new PdfReader(byArray);
        AcroFields acroFields = pdfReader.getAcroFields();
        List list = acroFields.getSignatureNames();
        for (String string : list) {
            PdfPKCS7 pdfPKCS7 = acroFields.verifySignature(string);
            PdfDictionary pdfDictionary = acroFields.getSignatureDictionary(string);
            if (!PDFNAME_ETSI_RFC3161.equals((Object)pdfDictionary.get(PdfName.SUBFILTER)) && !PDFNAME_DOCTIMESTAMP.equals((Object)pdfDictionary.get(PdfName.SUBFILTER))) {
                try {
                    if (!pdfPKCS7.verify()) {
                        return new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.NO_MATCH_DATA);
                    }
                }
                catch (Exception exception) {
                    LOGGER.warning("Error validando la firma '" + string + "' del PDF: " + exception);
                    return new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.CORRUPTED_SIGN);
                }
            }
            X509Certificate x509Certificate = pdfPKCS7.getSigningCertificate();
            try {
                x509Certificate.checkValidity();
            }
            catch (CertificateExpiredException certificateExpiredException) {
                LOGGER.info("El certificado usado ha expirado: " + certificateExpiredException);
                return new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.CERTIFICATE_EXPIRED);
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                LOGGER.info("El certificado usado todavia no es valido: " + certificateNotYetValidException);
                return new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.CERTIFICATE_NOT_VALID_YET);
            }
        }
        return new SignValidity(SignValidity.SIGN_DETAIL_TYPE.OK, null);
    }
}

