/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.cert.signvalidation;

import es.gob.afirma.cert.signvalidation.SignValider;
import es.gob.afirma.cert.signvalidation.SignValidity;
import es.gob.afirma.signers.xml.Utils;
import es.gob.afirma.signers.xml.dereference.CustomUriDereferencer;
import java.io.ByteArrayInputStream;
import java.security.Key;
import java.security.KeyException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public final class ValidateXMLSignature
implements SignValider {
    static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final SignValidity KO = new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, null);

    @Override
    public SignValidity validate(byte[] byArray) {
        Document document;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            document = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(byArray));
        }
        catch (Exception exception) {
            return new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.CORRUPTED_SIGN);
        }
        NodeList nodeList = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nodeList.getLength() == 0) {
            return new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.NO_SIGN);
        }
        try {
            Object object;
            DOMValidateContext dOMValidateContext = new DOMValidateContext(new KeyValueKeySelector(), nodeList.item(0));
            XMLSignature xMLSignature = Utils.getDOMFactory().unmarshalXMLSignature(dOMValidateContext);
            if (!xMLSignature.validate(dOMValidateContext)) {
                LOGGER.info("La firma es invalida");
                return KO;
            }
            if (!xMLSignature.getSignatureValue().validate(dOMValidateContext)) {
                LOGGER.info("El valor de la firma es invalido");
                return KO;
            }
            XMLSignatureFactory xMLSignatureFactory = XMLSignatureFactory.getInstance("DOM");
            XMLSignature xMLSignature2 = xMLSignatureFactory.unmarshalXMLSignature(dOMValidateContext);
            KeyInfo keyInfo = xMLSignature2.getKeyInfo();
            X509Certificate x509Certificate = null;
            for (XMLStructure object22 : keyInfo.getContent()) {
                if (!(object22 instanceof X509Data)) continue;
                X509Data n = (X509Data)object22;
                object = n.getContent();
                for (int i = 0; i < object.size(); ++i) {
                    if (!(object.get(i) instanceof X509Certificate)) continue;
                    x509Certificate = (X509Certificate)object.get(i);
                    try {
                        x509Certificate.checkValidity();
                        continue;
                    }
                    catch (CertificateExpiredException certificateNotYetValidException) {
                        LOGGER.info("El certificado de la firma ha expirado: " + certificateNotYetValidException);
                        return new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.CERTIFICATE_EXPIRED);
                    }
                    catch (CertificateNotYetValidException certificateNotYetValidException) {
                        LOGGER.info("El certificado de la firma no es valido todavia: " + certificateNotYetValidException);
                        return new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.CERTIFICATE_NOT_VALID_YET);
                    }
                }
            }
            Iterator<Reference> iterator = xMLSignature.getSignedInfo().getReferences().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                object = iterator.next();
                if (!object.validate(dOMValidateContext)) {
                    LOGGER.info("La referencia " + n + " de la firma es invalida");
                    return KO;
                }
                ++n;
            }
            return new SignValidity(SignValidity.SIGN_DETAIL_TYPE.OK, null);
        }
        catch (Exception exception) {
            LOGGER.warning("No se ha podido validar la firma: " + exception);
            return new SignValidity(SignValidity.SIGN_DETAIL_TYPE.UNKNOWN, null);
        }
    }

    private static final class SimpleKeySelectorResult
    implements KeySelectorResult {
        private final PublicKey pk;

        SimpleKeySelectorResult(PublicKey publicKey) {
            this.pk = publicKey;
        }

        @Override
        public Key getKey() {
            return this.pk;
        }
    }

    static final class KeyValueKeySelector
    extends KeySelector {
        KeyValueKeySelector() {
        }

        @Override
        public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod algorithmMethod, XMLCryptoContext xMLCryptoContext) throws KeySelectorException {
            if (keyInfo == null) {
                throw new KeySelectorException("Objeto KeyInfo nulo");
            }
            List<XMLStructure> list = keyInfo.getContent();
            try {
                xMLCryptoContext.setURIDereferencer((URIDereferencer)new CustomUriDereferencer());
            }
            catch (Exception exception) {
                LOGGER.warning("No se ha podido instalar un dereferenciador a medida: " + exception);
            }
            for (int i = 0; i < list.size(); ++i) {
                Object object;
                XMLStructure xMLStructure = list.get(i);
                if (xMLStructure instanceof KeyValue) {
                    try {
                        object = ((KeyValue)xMLStructure).getPublicKey();
                    }
                    catch (KeyException keyException) {
                        throw new KeySelectorException(keyException);
                    }
                    return new SimpleKeySelectorResult((PublicKey)object);
                }
                if (!(xMLStructure instanceof X509Data)) continue;
                object = ((X509Data)xMLStructure).getContent();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!(e instanceof Certificate)) continue;
                    return new SimpleKeySelectorResult(((Certificate)e).getPublicKey());
                }
            }
            throw new KeySelectorException("No se ha encontrado la clave publica dentro del XML firmado");
        }
    }
}

