/*
 * Decompiled with CFR 0.152.
 */
package es.indaba.sqld.annotations.cdi.extension;

import es.indaba.sqld.annotations.cdi.api.QueryRepositories;
import es.indaba.sqld.annotations.cdi.api.QueryRepository;
import es.indaba.sqld.annotations.cdi.extension.ContextualFactory;
import es.indaba.sqld.api.QueryDefinitionRepository;
import es.indaba.sqld.impl.loader.QueryDefinitionClassPathLoader;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.WithAnnotations;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.util.bean.BeanBuilder;
import org.apache.deltaspike.core.util.metadata.builder.ContextualLifecycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryDefinitionCDIExtension
implements Extension {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryDefinitionCDIExtension.class);
    private Bean<QueryDefinitionRepository> bean;
    private final Set<String> repositoryPrefixes = new HashSet<String>();

    public <T> void processAnnotatedType(@WithAnnotations(value={QueryRepository.class, QueryRepositories.class}) @Observes ProcessAnnotatedType<T> pat, BeanManager bm) {
        Set annotated = pat.getAnnotatedType().getAnnotations();
        String className = pat.getAnnotatedType().getBaseType().getTypeName();
        for (Annotation annotation : annotated) {
            if (annotation instanceof QueryRepository) {
                String prefixLookup = ((QueryRepository)annotation).value();
                this.repositoryPrefixes.add(prefixLookup);
                LOGGER.debug("Query repository detected {}, prefix {}", (Object)className, (Object)prefixLookup);
                this.registerRepositoryBean(bm);
                continue;
            }
            if (!(annotation instanceof QueryRepositories)) continue;
            QueryRepository[] repositories = ((QueryRepositories)annotation).value();
            this.registerRepositoryBean(bm);
            for (QueryRepository repository : Arrays.asList(repositories)) {
                String prefixLookup = repository.value();
                this.repositoryPrefixes.add(prefixLookup);
                LOGGER.debug("Query repository detected {}, prefix {}", (Object)className, (Object)prefixLookup);
            }
        }
    }

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery abd) {
        if (this.bean != null) {
            abd.addBean(this.bean);
            this.bean = null;
        }
    }

    public void afterDeploymentValidation(@Observes AfterDeploymentValidation adv) {
        if (!this.repositoryPrefixes.isEmpty()) {
            QueryDefinitionRepository repository = (QueryDefinitionRepository)BeanProvider.getContextualReference(QueryDefinitionRepository.class, (Annotation[])new Annotation[0]);
            for (String prefixLookup : this.repositoryPrefixes) {
                QueryDefinitionClassPathLoader.loadQueryDefinitionFiles((String)prefixLookup, (QueryDefinitionRepository)repository);
            }
            this.repositoryPrefixes.clear();
        }
    }

    private void registerRepositoryBean(BeanManager bm) {
        if (this.bean == null) {
            BeanBuilder beanBuilder = new BeanBuilder(bm).passivationCapable(false).beanClass(QueryDefinitionRepository.class).scope(ApplicationScoped.class).name(QueryDefinitionRepository.class.getName()).beanLifecycle((ContextualLifecycle)new ContextualFactory());
            this.bean = beanBuilder.create();
        }
    }
}

