/*
 * Decompiled with CFR 0.152.
 */
package es.iti.commons.jext.spring;

import es.iti.commons.jext.ExtensionLoader;
import es.iti.commons.jext.spring.ApplicationContextProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringExtensionLoader
implements ExtensionLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringExtensionLoader.class);

    public <T> Iterable<T> load(Class<T> type, ClassLoader loader) {
        if (ApplicationContextProvider.hasContext()) {
            LOGGER.trace("Getting beans of type {}...", type);
            Collection beans = ApplicationContextProvider.applicationContext().getBeansOfType(type).values();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("{} beans found [{}]", (Object)beans.size(), (Object)beans.stream().map(Object::getClass).map(Class::getCanonicalName).collect(Collectors.joining(", ")));
            }
            return beans;
        }
        LOGGER.warn("Trying to load extension but ApplicationContextProvider has not been set yet!");
        return Collections.emptyList();
    }
}

