/*
 * Copyright (c) 2016 Lite Solutions
 *
 *  This code is licensed under the Apache Software License version 2.
 *  For more information, see the LICENSE file at the root of this package.
 *
 *  Should you not have the source code available, and the file above is
 *  unavailable, you can obtain a copy of the license here:
 *
 *  https://www.apache.org/licenses/LICENSE-2.0.txt
 *
 */

package es.litesolutions.sonar.grappa.listeners;

import com.github.fge.grappa.run.ParseRunnerListener;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.impl.Lexer;
import es.litesolutions.sonar.grappa.GrappaChannel;
import org.sonar.sslr.channel.CodeReader;

import javax.annotation.Nonnull;

/**
 * Create a {@link ParseRunnerListener} given a {@link CodeReader} and a {@link
 * Lexer} as arguments
 *
 * <p>This allows you to register listeners to a {@link GrappaChannel}.</p>
 */
@FunctionalInterface
public interface ListenerSupplier
{
    @Nonnull
    ParseRunnerListener<Token.Builder> create(final CodeReader reader,
        final Lexer lexer);
}
