/*
 * Decompiled with CFR 0.152.
 */
package es.litesolutions.sonar.grappa;

import com.github.fge.grappa.buffers.InputBuffer;
import com.github.fge.grappa.buffers.LineCounter;
import com.github.fge.grappa.support.IndexRange;
import com.github.fge.grappa.support.Position;
import java.nio.CharBuffer;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.sonar.sslr.channel.CodeReader;
import r.com.google.common.base.Preconditions;
import r.com.google.common.collect.Range;
import r.com.google.common.util.concurrent.Futures;
import r.com.google.common.util.concurrent.ThreadFactoryBuilder;

@Immutable
public final class CodeReaderInputBuffer
implements InputBuffer {
    private static final ExecutorService EXECUTOR_SERVICE;
    private final CodeReader reader;
    private final int length;
    private final Future<LineCounter> lineCounter;

    public CodeReaderInputBuffer(@Nonnull CodeReader reader) {
        this.reader = Objects.requireNonNull(reader);
        this.length = reader.length();
        this.lineCounter = EXECUTOR_SERVICE.submit(() -> new LineCounter((CharSequence)reader));
    }

    public char charAt(int index) {
        return index >= 0 && index < this.length ? this.reader.charAt(index) : (char)'\uffff';
    }

    public int codePointAt(int index) {
        if (index >= this.length) {
            return -1;
        }
        if (index < 0) {
            throw new IllegalArgumentException("index is negative");
        }
        int c = this.reader.charAt(index);
        if (!Character.isHighSurrogate((char)c)) {
            return c;
        }
        if (index == this.length - 1) {
            return c;
        }
        char c2 = this.reader.charAt(index + 1);
        return Character.isLowSurrogate(c2) ? Character.toCodePoint((char)c, c2) : c;
    }

    public String extract(int start, int end) {
        int realStart = Math.max(start, 0);
        int realEnd = Math.min(end, this.length);
        CharBuffer buf = CharBuffer.allocate(realEnd - realStart);
        for (int i = realStart; i < realEnd; ++i) {
            buf.put(this.charAt(i));
        }
        return new String(buf.array());
    }

    public String extract(IndexRange range) {
        return this.extract(range.start, range.end);
    }

    public Position getPosition(int index) {
        Position position = ((LineCounter)Futures.getUnchecked(this.lineCounter)).toPosition(index);
        return new Position(position.getLine(), position.getColumn() - 1);
    }

    public String extractLine(int lineNumber) {
        Preconditions.checkArgument((lineNumber > 0 ? 1 : 0) != 0, (Object)"line number is negative");
        LineCounter counter = (LineCounter)Futures.getUnchecked(this.lineCounter);
        Range range = counter.getLineRange(lineNumber);
        int start = (Integer)range.lowerEndpoint();
        int end = (Integer)range.upperEndpoint();
        if (this.charAt(end - 1) == '\n') {
            --end;
        }
        if (this.charAt(end - 1) == '\r') {
            --end;
        }
        return this.extract(start, end);
    }

    public IndexRange getLineRange(int lineNumber) {
        Range range = ((LineCounter)Futures.getUnchecked(this.lineCounter)).getLineRange(lineNumber);
        return new IndexRange(((Integer)range.lowerEndpoint()).intValue(), ((Integer)range.upperEndpoint()).intValue());
    }

    public int getLineCount() {
        return ((LineCounter)Futures.getUnchecked(this.lineCounter)).getNrLines();
    }

    public int length() {
        return this.length;
    }

    static {
        ThreadFactory factory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("linecounter-thread-%d").build();
        EXECUTOR_SERVICE = Executors.newCachedThreadPool(factory);
    }
}

