/*
 * Decompiled with CFR 0.152.
 */
package es.litesolutions.sonar.grappa;

import com.github.fge.grappa.exceptions.GrappaException;
import com.github.fge.grappa.matchers.base.Matcher;
import com.github.fge.grappa.run.ParseRunnerListener;
import com.github.fge.grappa.run.ParsingResult;
import com.github.fge.grappa.run.context.MatcherContext;
import com.github.fge.grappa.run.events.MatchFailureEvent;
import com.github.fge.grappa.run.events.MatchSuccessEvent;
import com.github.fge.grappa.run.events.PostParseEvent;
import com.github.fge.grappa.run.events.PreParseEvent;
import com.github.fge.grappa.stack.ValueStack;
import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import com.sonar.sslr.impl.Lexer;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.sslr.channel.CodeReader;

public final class CodeReaderListener
extends ParseRunnerListener<Token.Builder> {
    private final Lexer lexer;
    private final CodeReader reader;
    private static final Logger LOG = LoggerFactory.getLogger(CodeReaderListener.class);
    private Matcher rootMatcher = null;
    private int consumed = 0;

    public CodeReaderListener(CodeReader reader, Lexer lexer) {
        this.lexer = lexer;
        this.reader = reader;
    }

    public void beforeParse(PreParseEvent<Token.Builder> event) {
        MatcherContext context = event.getContext();
        this.rootMatcher = context.getMatcher();
    }

    public void matchSuccess(MatchSuccessEvent<Token.Builder> event) {
        MatcherContext context = event.getContext();
        if (!context.inPredicate()) {
            this.consumed = Math.max(this.consumed, context.getCurrentIndex());
        }
        if (context.getLevel() != 0) {
            return;
        }
        if (context.getMatcher() != this.rootMatcher) {
            throw new IllegalStateException("was expecting root rule here");
        }
    }

    public void matchFailure(MatchFailureEvent<Token.Builder> event) {
        MatcherContext context = event.getContext();
        if (context.getLevel() != 0) {
            return;
        }
        if (context.getMatcher() != this.rootMatcher) {
            throw new IllegalStateException("was expecting root rule here");
        }
    }

    public void afterParse(PostParseEvent<Token.Builder> event) {
        int length = this.reader.length();
        ParsingResult result = event.getResult();
        if (!result.isSuccess()) {
            throw new GrappaException("match failure (consumed: " + this.consumed + " out of " + length + ')');
        }
        if (this.consumed != length) {
            char u;
            int i;
            int saltoLineaIni = this.consumed;
            int saltoLineaEnd = this.consumed;
            for (i = this.consumed; i > 0; --i) {
                u = this.reader.charAt(i);
                if (u != '\n' && u != '\r') continue;
                saltoLineaIni = i;
                break;
            }
            for (i = this.consumed; i < length; ++i) {
                u = this.reader.charAt(i);
                if (u != '\n' && u != '\r') continue;
                saltoLineaEnd = i;
                break;
            }
            String lineToShow = "";
            for (int i2 = saltoLineaIni; i2 < saltoLineaEnd; ++i2) {
                lineToShow = lineToShow + this.reader.charAt(i2);
            }
            LOG.error("LINE ERROR: " + lineToShow);
            throw new GrappaException("was expecting to fully match, but only " + this.consumed + " chars were matched out of " + length);
        }
        ValueStack stack = result.getValueStack();
        URI uri = this.lexer.getURI();
        int size = stack.size();
        for (int index = size - 1; index >= 0; --index) {
            Token token = ((Token.Builder)stack.peek(index)).setURI(uri).build();
            if (token.getType() == GenericTokenType.COMMENT) {
                this.lexer.addTrivia(new Trivia[]{Trivia.createComment((Token)token)});
                continue;
            }
            this.lexer.addToken(new Token[]{token});
        }
    }
}

