/*
 * Decompiled with CFR 0.152.
 */
package es.litesolutions.sonar.grappa;

import com.github.fge.grappa.buffers.InputBuffer;
import com.github.fge.grappa.rules.Rule;
import com.github.fge.grappa.run.ListeningParseRunner;
import com.sonar.sslr.impl.Lexer;
import es.litesolutions.sonar.grappa.CodeReaderInputBuffer;
import es.litesolutions.sonar.grappa.CodeReaderListener;
import es.litesolutions.sonar.grappa.listeners.ListenerSupplier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import org.sonar.sslr.channel.Channel;
import org.sonar.sslr.channel.CodeReader;

@ParametersAreNonnullByDefault
public final class GrappaChannel
extends Channel<Lexer> {
    private final Rule rule;
    private final Collection<ListenerSupplier> suppliers = new ArrayList<ListenerSupplier>();

    public GrappaChannel(Rule rule) {
        this.rule = rule;
        this.suppliers.add(CodeReaderListener::new);
    }

    public void addListenerSupplier(ListenerSupplier supplier) {
        this.suppliers.add(Objects.requireNonNull(supplier));
    }

    public boolean consume(CodeReader code, Lexer output) {
        CodeReaderInputBuffer buffer = new CodeReaderInputBuffer(code);
        ListeningParseRunner runner = new ListeningParseRunner(this.rule);
        this.suppliers.stream().map(supplier -> supplier.create(code, output)).forEach(arg_0 -> ((ListeningParseRunner)runner).registerListener(arg_0));
        runner.run((InputBuffer)buffer);
        int length = code.length();
        for (int i = 0; i < length; ++i) {
            code.pop();
        }
        return true;
    }
}

