/*
 * Decompiled with CFR 0.152.
 */
package es.litesolutions.sonar.grappa;

import com.github.fge.grappa.Grappa;
import com.github.fge.grappa.rules.Rule;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.impl.Lexer;
import com.sonar.sslr.impl.Parser;
import es.litesolutions.sonar.grappa.GrappaChannel;
import es.litesolutions.sonar.grappa.SonarParserBase;
import es.litesolutions.sonar.grappa.injector.GrammarInjector;
import es.litesolutions.sonar.grappa.injector.LegacyGrammarInjector;
import es.litesolutions.sonar.grappa.listeners.ListenerSupplier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import org.sonar.sslr.channel.Channel;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.grammar.LexerfulGrammarBuilder;

@ParametersAreNonnullByDefault
public final class GrappaSslrFactory {
    private final Rule rule;
    private final GrammarInjector injector;
    private final GrammarRuleKey entryPoint;
    private final Collection<ListenerSupplier> suppliers;

    public static <P extends SonarParserBase> Builder<P> withParserClass(Class<P> parserClass) {
        return new Builder(parserClass);
    }

    private <P extends SonarParserBase> GrappaSslrFactory(Builder<P> builder) {
        SonarParserBase parser = (SonarParserBase)Grappa.createParser((Class)((Builder)builder).parserClass, (Object[])new Object[0]);
        this.rule = (Rule)((Builder)builder).ruleFunction.apply(parser);
        this.injector = ((Builder)builder).injector;
        this.entryPoint = ((Builder)builder).entryPoint;
        this.suppliers = Collections.unmodifiableCollection(((Builder)builder).suppliers);
    }

    public Parser<Grammar> getParser() {
        GrappaChannel channel = new GrappaChannel(this.rule);
        this.suppliers.forEach(channel::addListenerSupplier);
        LexerfulGrammarBuilder builder = this.getGrammarBuilder();
        builder.setRootRule(this.entryPoint);
        Lexer lexer = Lexer.builder().withFailIfNoChannelToConsumeOneCharacter(true).withChannel((Channel)channel).build();
        return Parser.builder((Grammar)builder.build()).withLexer(lexer).build();
    }

    private LexerfulGrammarBuilder getGrammarBuilder() {
        LexerfulGrammarBuilder builder = LexerfulGrammarBuilder.create();
        this.injector.injectInto(builder);
        return builder;
    }

    public static final class Builder<P extends SonarParserBase> {
        private final Class<P> parserClass;
        private Function<P, Rule> ruleFunction;
        private GrammarRuleKey entryPoint;
        private GrammarInjector injector;
        private final Collection<ListenerSupplier> suppliers = new HashSet<ListenerSupplier>();

        private Builder(Class<P> parserClass) {
            this.parserClass = Objects.requireNonNull(parserClass);
        }

        @Deprecated
        public Builder<P> withGrammarClass(Class<? extends GrammarRuleKey> grammarClass) {
            Objects.requireNonNull(grammarClass);
            this.injector = new LegacyGrammarInjector(grammarClass);
            return this;
        }

        public Builder<P> withGrammarInjector(GrammarInjector injector) {
            this.injector = Objects.requireNonNull(injector);
            return this;
        }

        public Builder<P> withEntryPoint(GrammarRuleKey entryPoint) {
            this.entryPoint = Objects.requireNonNull(entryPoint);
            return this;
        }

        public Builder<P> withMainRule(Function<P, Rule> ruleFunction) {
            this.ruleFunction = Objects.requireNonNull(ruleFunction);
            return this;
        }

        public Builder<P> addListenerSupplier(ListenerSupplier supplier) {
            this.suppliers.add(Objects.requireNonNull(supplier));
            return this;
        }

        public GrappaSslrFactory build() {
            Objects.requireNonNull(this.ruleFunction, "no rule has been defined");
            Objects.requireNonNull(this.injector, "no grammar injector has been defined");
            Objects.requireNonNull(this.entryPoint, "no grammar entry point has been defined");
            return new GrappaSslrFactory(this);
        }
    }
}

