/*
 * Decompiled with CFR 0.152.
 */
package es.litesolutions.sonar.grappa.injector;

import com.github.fge.grappa.exceptions.GrappaException;
import es.litesolutions.sonar.grappa.injector.GrammarInjector;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.grammar.LexerfulGrammarBuilder;

public final class LegacyGrammarInjector
implements GrammarInjector {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.publicLookup();
    private static final String INJECTOR_NAME = "injectInto";
    private static final MethodType INJECTOR_TYPE = MethodType.methodType(Void.TYPE, LexerfulGrammarBuilder.class);
    private final MethodHandle injector;

    public LegacyGrammarInjector(Class<? extends GrammarRuleKey> c) {
        this.injector = LegacyGrammarInjector.findInjector(c);
    }

    @Override
    public void injectInto(LexerfulGrammarBuilder builder) {
        try {
            this.injector.invokeExact(builder);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable throwable) {
            throw new GrappaException("unable to invoke grammar injector", throwable);
        }
    }

    private static MethodHandle findInjector(Class<?> grammarClass) {
        try {
            return LOOKUP.findStatic(grammarClass, INJECTOR_NAME, INJECTOR_TYPE);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new GrappaException("unable to find injection method for class " + grammarClass.getName(), (Throwable)e);
        }
    }
}

