/*
 * Decompiled with CFR 0.152.
 */
package es.moki.ratelimij.dropwizard;

import es.moki.ratelimij.dropwizard.RateLimiting;
import es.moki.ratelimij.dropwizard.filter.RateLimited429EnforcerFeature;
import es.moki.ratelimitj.core.limiter.request.RequestRateLimiterFactory;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.server.internal.inject.AbstractContainerRequestValueFactory;
import org.glassfish.jersey.server.internal.inject.AbstractValueFactoryProvider;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.internal.inject.ParamInjectionResolver;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.spi.internal.ValueFactoryProvider;

public class RateLimitBundle
implements ConfiguredBundle<Configuration> {
    private final RequestRateLimiterFactory requestRateLimiterFactory;

    public RateLimitBundle(RequestRateLimiterFactory requestRateLimiterFactory) {
        this.requestRateLimiterFactory = Objects.requireNonNull(requestRateLimiterFactory);
    }

    public void initialize(Bootstrap<?> bootstrap) {
    }

    public void run(Configuration configuration, Environment environment) {
        environment.jersey().register((Object)new RateLimitingFactoryProvider.Binder(this.requestRateLimiterFactory));
        environment.jersey().register((Object)new RateLimited429EnforcerFeature());
        environment.lifecycle().manage(new Managed(){

            public void start() {
            }

            public void stop() throws Exception {
                RateLimitBundle.this.requestRateLimiterFactory.close();
            }
        });
    }

    @Singleton
    public static class RateLimitingFactoryProvider
    extends AbstractValueFactoryProvider {
        private RequestRateLimiterFactory requestRateLimiterFactory;

        @Inject
        public RateLimitingFactoryProvider(MultivaluedParameterExtractorProvider extractorProvider, ServiceLocator injector, RateLimiterFactoryProvider rateLimiterFactoryProvider) {
            super(extractorProvider, injector, new Parameter.Source[]{Parameter.Source.UNKNOWN});
            this.requestRateLimiterFactory = rateLimiterFactoryProvider.factory;
        }

        protected Factory<RequestRateLimiterFactory> createValueFactory(Parameter parameter) {
            RateLimiting annotation = (RateLimiting)parameter.getAnnotation(RateLimiting.class);
            if (null == annotation) {
                return null;
            }
            return new AbstractContainerRequestValueFactory<RequestRateLimiterFactory>(){

                public RequestRateLimiterFactory provide() {
                    return requestRateLimiterFactory;
                }
            };
        }

        public static class Binder
        extends AbstractBinder {
            private final RequestRateLimiterFactory requestRateLimiterFactory;

            public Binder(RequestRateLimiterFactory requestRateLimiterFactory) {
                this.requestRateLimiterFactory = requestRateLimiterFactory;
            }

            protected void configure() {
                this.bind(new RateLimiterFactoryProvider(this.requestRateLimiterFactory)).to(RateLimiterFactoryProvider.class);
                this.bind(RateLimitingFactoryProvider.class).to(ValueFactoryProvider.class).in(Singleton.class);
                this.bind(RateLimitingInjectionResolver.class).to((TypeLiteral)new TypeLiteral<InjectionResolver<RateLimiting>>(){}).in(Singleton.class);
            }
        }

        @Singleton
        public static class RateLimiterFactoryProvider {
            private final RequestRateLimiterFactory factory;

            RateLimiterFactoryProvider(RequestRateLimiterFactory factory) {
                this.factory = factory;
            }
        }

        public static class RateLimitingInjectionResolver
        extends ParamInjectionResolver<RateLimiting> {
            public RateLimitingInjectionResolver() {
                super(RateLimitingFactoryProvider.class);
            }
        }
    }
}

