/*
 * Decompiled with CFR 0.152.
 */
package es.moki.ratelimij.dropwizard.filter;

import es.moki.ratelimij.dropwizard.filter.KeyProvider;
import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.SecurityContext;

@ParametersAreNonnullByDefault
public enum KeyPart implements KeyProvider
{
    ANY{

        @Override
        public Optional<CharSequence> create(HttpServletRequest request, ResourceInfo resource, SecurityContext securityContext) {
            return 1.selectOptional(() -> 1.userRequestKey(securityContext), () -> 1.xForwardedForRequestKey(request), () -> 1.ipRequestKey(request));
        }
    }
    ,
    AUTHENTICATED{

        @Override
        public Optional<CharSequence> create(HttpServletRequest request, ResourceInfo resource, SecurityContext securityContext) {
            return 2.userRequestKey(securityContext);
        }
    }
    ,
    IP{

        @Override
        public Optional<CharSequence> create(HttpServletRequest request, ResourceInfo resource, SecurityContext securityContext) {
            return 3.selectOptional(() -> 3.xForwardedForRequestKey(request), () -> 3.ipRequestKey(request));
        }
    }
    ,
    RESOURCE_NAME{

        @Override
        public Optional<CharSequence> create(HttpServletRequest request, ResourceInfo resource, SecurityContext securityContext) {
            return Optional.of(resource.getResourceClass().getTypeName() + "#" + resource.getResourceMethod().getName());
        }
    };

    private static final String X_FORWARDED_FOR = "X-Forwarded-For";

    static Optional<CharSequence> userRequestKey(SecurityContext securityContext) {
        Principal userPrincipal = securityContext.getUserPrincipal();
        if (Objects.isNull(userPrincipal)) {
            return Optional.empty();
        }
        return Optional.of("usr#" + userPrincipal.getName());
    }

    static Optional<CharSequence> xForwardedForRequestKey(HttpServletRequest request) {
        String header = request.getHeader(X_FORWARDED_FOR);
        if (Objects.isNull(header)) {
            return Optional.empty();
        }
        Optional<String> originatingClientIp = Stream.of(header.split(",")).findFirst();
        return originatingClientIp.map(ip -> "xfwd4#" + ip);
    }

    static Optional<CharSequence> ipRequestKey(HttpServletRequest request) {
        String remoteAddress = request.getRemoteAddr();
        if (Objects.isNull(remoteAddress)) {
            return Optional.empty();
        }
        return Optional.of("ip#" + remoteAddress);
    }

    @SafeVarargs
    static <T> Optional<T> selectOptional(Supplier<Optional<T>> ... optionals) {
        return Arrays.stream(optionals).reduce((s1, s2) -> () -> KeyPart.lambda$null$1((Supplier)s1, (Supplier)s2)).orElse(Optional::empty).get();
    }

    public static Optional<CharSequence> combineKeysParts(CharSequence groupKeyPrefix, List<KeyProvider> keyParts, HttpServletRequest request, ResourceInfo resource, SecurityContext securityContext) {
        List keys = Stream.concat(Stream.of(groupKeyPrefix), keyParts.stream().map(keyPart -> keyPart.create(request, resource, securityContext)).filter(Optional::isPresent).map(Optional::get)).collect(Collectors.toList());
        if (keys.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(keys.stream().collect(Collectors.joining(":", "rlj", "")));
    }

    private static /* synthetic */ Optional lambda$null$1(Supplier s1, Supplier s2) {
        return ((Optional)s1.get()).map(Optional::of).orElseGet(s2);
    }
}

