/*
 * Decompiled with CFR 0.152.
 */
package es.moki.ratelimij.dropwizard.filter;

import es.moki.ratelimij.dropwizard.RateLimiting;
import es.moki.ratelimij.dropwizard.annotation.Rate;
import es.moki.ratelimij.dropwizard.annotation.RateLimited;
import es.moki.ratelimij.dropwizard.filter.KeyPart;
import es.moki.ratelimitj.core.limiter.request.RequestLimitRule;
import es.moki.ratelimitj.core.limiter.request.RequestRateLimiter;
import es.moki.ratelimitj.core.limiter.request.RequestRateLimiterFactory;
import java.time.Duration;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.glassfish.jersey.server.model.AnnotatedMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=1001)
public class RateLimit429EnforcerFilter
implements ContainerRequestFilter {
    private static final int HTTP_STATUS_TOO_MANY_REQUESTS = 429;
    private static final Logger LOG = LoggerFactory.getLogger(RateLimit429EnforcerFilter.class);
    @RateLimiting
    private RequestRateLimiterFactory factory;
    @Context
    private HttpServletRequest request;
    @Context
    private ResourceInfo resource;
    @Context
    private SecurityContext securityContext;

    public void filter(ContainerRequestContext requestContext) {
        try {
            AnnotatedMethod method = new AnnotatedMethod(this.resource.getResourceMethod());
            RateLimited rateLimited = (RateLimited)method.getAnnotation(RateLimited.class);
            RequestRateLimiter rateLimit = this.factory.getInstance(this.toLimitRules(rateLimited));
            KeyPart[] keyParts = rateLimited.keys();
            Optional<CharSequence> keyResult = KeyPart.combineKeysParts(rateLimited.groupKeyPrefix(), Arrays.asList(keyParts), this.request, this.resource, this.securityContext);
            if (!keyResult.isPresent()) {
                LOG.warn("No keys were provided by the key providers '{}'", (Object)Arrays.stream(keyParts).map(Object::getClass).map(Object::toString).collect(Collectors.joining(", ")));
                return;
            }
            CharSequence key = keyResult.get();
            boolean overLimit = rateLimit.overLimitWhenIncremented(key.toString());
            if (overLimit) {
                if (!rateLimited.reportOnly()) {
                    LOG.info("rate-limit key '{}' over limit. HTTP Status 429 returned.", (Object)key);
                    requestContext.abortWith(Response.status((int)429).build());
                } else {
                    LOG.info("rate-limit key '{}' over limit. ReportOnly is true, no action taken.", (Object)key);
                }
                LOG.debug("rate-limit key '{}' under limit.", (Object)key);
            }
        }
        catch (Exception e) {
            LOG.error("Error occurred checking rate-limit. Assuming under limit", (Throwable)e);
        }
    }

    private Set<RequestLimitRule> toLimitRules(RateLimited rateLimited) {
        return Arrays.stream(rateLimited.rates()).map(this::toLimitRule).collect(Collectors.toSet());
    }

    private RequestLimitRule toLimitRule(Rate rate) {
        return RequestLimitRule.of((Duration)Duration.ofMillis(rate.timeUnit().toMillis(rate.duration())), (long)rate.limit());
    }
}

