/*
 * Decompiled with CFR 0.152.
 */
package es.molabs.io.utils;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;

public class FileHelper {
    private static final String EXTENSION_PROPERTIES = "properties";

    private FileHelper() {
    }

    public static URL[] getFiles(URL path) throws IOException {
        return FileHelper.getFiles(path, false, EXTENSION_PROPERTIES);
    }

    public static URL[] getFiles(URL path, boolean recursive) throws IOException {
        return FileHelper.getFiles(path, recursive, EXTENSION_PROPERTIES);
    }

    public static URL[] getFiles(URL path, boolean recursive, String ... extensions) throws IOException {
        URL[] urls = null;
        try {
            Collection fileCollection = FileUtils.listFiles((File)new File(path.toURI()), (String[])extensions, (boolean)recursive);
            urls = new URL[fileCollection.size()];
            Iterator iterator = fileCollection.iterator();
            int index = 0;
            while (iterator.hasNext()) {
                File file = (File)iterator.next();
                urls[index++] = file.toURI().toURL();
            }
        }
        catch (URISyntaxException USe) {
            throw new IOException(USe);
        }
        return urls;
    }
}

