/*
 * Decompiled with CFR 0.152.
 */
package es.molabs.io.utils;

import es.molabs.io.utils.FileWatcherHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileWatcherRunnable
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private WatchService watchService = null;
    private Set<URL> fileSet = null;
    private long refreshTime;
    private FileWatcherHandler handler = null;

    public FileWatcherRunnable(WatchService watchService, FileWatcherHandler handler) throws IOException {
        this(watchService, new HashSet<URL>(), 1000L, handler);
    }

    public FileWatcherRunnable(WatchService watchService, Set<URL> fileSet, long refreshTime, FileWatcherHandler handler) throws IOException {
        this.watchService = watchService;
        this.fileSet = fileSet;
        this.refreshTime = refreshTime;
        this.handler = handler;
        Iterator<URL> iterator = fileSet.iterator();
        while (iterator.hasNext()) {
            this.addToWatchService(iterator.next());
        }
    }

    public void addFile(URL file) throws IOException {
        this.fileSet.add(file);
        this.addToWatchService(file);
    }

    public void setRefreshTime(long refreshTime) {
        this.refreshTime = refreshTime;
    }

    public long getRefreshTime() {
        return this.refreshTime;
    }

    private void addToWatchService(URL url) throws IOException {
        String path = null;
        try {
            File file = new File(url.toURI());
            path = file.isDirectory() ? file.toString() : new File(url.toURI()).getParent();
        }
        catch (URISyntaxException USe) {
            throw new FileNotFoundException(USe.getLocalizedMessage());
        }
        Path pathToWatch = Paths.get(path, new String[0]);
        if (pathToWatch == null) {
            throw new FileNotFoundException(path);
        }
        pathToWatch.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.OVERFLOW);
        this.logger.debug("Path Added [{}]", (Object)pathToWatch);
    }

    @Override
    public void run() {
        try {
            WatchKey key = this.watchService.take();
            while (key != null) {
                Thread.sleep(this.refreshTime);
                for (WatchEvent<?> event : key.pollEvents()) {
                    Path path = (Path)key.watchable();
                    Path fullPath = path.resolve((Path)event.context());
                    URL urlFile = fullPath.toUri().toURL();
                    if (event.kind() == StandardWatchEventKinds.ENTRY_CREATE) {
                        this.logger.debug("Entry Create [{}].", (Object)urlFile);
                        this.handler.entryCreate(urlFile);
                        continue;
                    }
                    if (event.kind() == StandardWatchEventKinds.ENTRY_MODIFY) {
                        this.logger.debug("Entry Modify [{}].", (Object)urlFile);
                        this.handler.entryModify(urlFile);
                        continue;
                    }
                    if (event.kind() == StandardWatchEventKinds.ENTRY_DELETE) {
                        this.logger.debug("Entry Delete [{}].", (Object)urlFile);
                        this.handler.entryDelete(urlFile);
                        continue;
                    }
                    if (event.kind() != StandardWatchEventKinds.OVERFLOW) continue;
                    this.logger.debug("Entry Overflow [{}].", (Object)urlFile);
                    this.handler.overflow(urlFile);
                }
                key.reset();
                key = this.watchService.take();
            }
        }
        catch (ClosedWatchServiceException key) {
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

