/*
 * Decompiled with CFR 0.152.
 */
package es.molabs.io.utils;

import es.molabs.io.utils.FileWatcherHandler;
import es.molabs.io.utils.FileWatcherRunnable;
import es.molabs.properties.NodeProperties;
import es.molabs.properties.NodePropertiesKey;
import es.molabs.properties.NodePropertiesToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.WatchService;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodePropertiesBundle {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<NodePropertiesToken> tokenList = null;
    private NodePropertiesKey nodePropertiesKey = null;
    private NodeProperties nodeProperties = null;
    private ExecutorService executorService = null;
    private Map<URL, String> propertiesMap = null;
    private WatchService watchService = null;
    private FileWatcherRunnable fileWatcherRunnable = null;
    private boolean initialized;

    public NodePropertiesBundle(NodePropertiesToken ... tokenList) {
        this(Arrays.asList(tokenList));
    }

    public NodePropertiesBundle(List<NodePropertiesToken> tokenList) {
        this.tokenList = tokenList;
        this.nodePropertiesKey = new NodePropertiesKey(tokenList);
        this.nodeProperties = new NodeProperties(tokenList.size());
        this.propertiesMap = new LinkedHashMap<URL, String>();
        this.initialized = false;
    }

    public void init() throws IOException {
        if (!this.initialized) {
            this.initialized = true;
            this.watchService = FileSystems.getDefault().newWatchService();
            this.fileWatcherRunnable = new FileWatcherRunnable(this.watchService, new ConfigurationFileWatcherHandler());
            this.executorService = Executors.newSingleThreadExecutor(new WatchServiceThreadFactory());
            this.executorService.submit(this.fileWatcherRunnable);
            if (!this.propertiesMap.isEmpty()) {
                this.loadAll();
            }
            this.logger.info("Initialized.");
        } else {
            this.logger.warn("Already initialized.");
        }
    }

    public void destroy() throws IOException {
        if (this.initialized) {
            this.initialized = false;
            this.watchService.close();
            this.executorService.shutdown();
            this.nodeProperties.clear();
            this.logger.info("Destroyed.");
        } else {
            this.logger.warn("Already destroyed.");
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void addFile(URL resource) throws IOException {
        this.addFile(resource, StandardCharsets.ISO_8859_1.name());
    }

    public void addFile(URL resource, String encoding) throws IOException {
        if (this.initialized) {
            this.loadSingle(resource, encoding);
        }
        this.propertiesMap.put(resource, encoding);
    }

    public List<NodePropertiesToken> getTokenList() {
        return this.tokenList;
    }

    public String getString(String key) {
        return this.nodeProperties.getProperty(this.nodePropertiesKey.toKey(key));
    }

    private void loadAll() throws IOException {
        this.nodeProperties.clear();
        for (Map.Entry<URL, String> entry : this.propertiesMap.entrySet()) {
            this.loadSingle(entry.getKey(), entry.getValue());
        }
    }

    private void loadSingle(URL resource, String encoding) throws IOException {
        this.loadSingle(resource, encoding, this.nodeProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSingle(URL resource, String encoding, NodeProperties container) throws IOException {
        Properties propertiesToAdd = new Properties();
        try (InputStream inputStream = resource.openStream();){
            propertiesToAdd.load(new BufferedReader(new InputStreamReader(inputStream, encoding)));
        }
        container.load(propertiesToAdd);
        this.logger.info("Properties loaded [{}].", (Object)resource.getFile());
        if (resource.getProtocol().equals("file")) {
            this.fileWatcherRunnable.addFile(resource);
        }
    }

    private void reloadAll() throws IOException {
        NodeProperties newNodeProperties = new NodeProperties(this.tokenList.size());
        for (Map.Entry<URL, String> entry : this.propertiesMap.entrySet()) {
            this.loadSingle(entry.getKey(), entry.getValue(), newNodeProperties);
        }
        NodeProperties oldNodeProperties = this.nodeProperties;
        this.nodeProperties = newNodeProperties;
        oldNodeProperties.clear();
        oldNodeProperties = null;
        newNodeProperties = null;
    }

    private class ConfigurationFileWatcherHandler
    implements FileWatcherHandler {
        private final Logger logger = LoggerFactory.getLogger(this.getClass());

        private ConfigurationFileWatcherHandler() {
        }

        @Override
        public void entryCreate(URL file) {
        }

        @Override
        public void entryModify(URL file) {
            if (NodePropertiesBundle.this.propertiesMap.containsKey(file)) {
                this.logger.debug("File modified: " + file);
                this.logger.info("Reloading properties.");
                try {
                    NodePropertiesBundle.this.reloadAll();
                }
                catch (IOException IOe) {
                    this.logger.error(IOe.getLocalizedMessage(), (Throwable)IOe);
                }
                this.logger.info("Reloading finished.");
            }
        }

        @Override
        public void entryDelete(URL file) {
        }

        @Override
        public void overflow(URL file) {
        }
    }

    private class WatchServiceThreadFactory
    implements ThreadFactory {
        private AtomicInteger id = new AtomicInteger(0);

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "WatchServiceThread-" + this.id.getAndAdd(1));
        }
    }
}

